(function() {
	var open = false, timershow;
	var el = document.createElement("div");
	el.style.display = "none";
	el.className = "tooltip";
	document.body.appendChild(el);

	var position = function(x, y) {
		// position optimally, try to adjust when outside window.
		if (y + el.offsetHeight + 32 > window.innerHeight)
			el.style.top = String(y - el.offsetHeight - 18) + "px";
		else
			el.style.top = String(y + 18) + "px"; // + space for cursor height.
		// NOTE, this is a mess: document.body.clientWidth excludes scrollbar width.
		//      window.innerWidth is the window including scrollbar width.
		//      window.outerWidth is the window including scrollbar width and window border.
		if (x + el.offsetWidth >= document.body.parentNode.offsetWidth) {
			el.style.right = "0px";
			el.style.left = "auto";
		} else {
			el.style.left = String(x) + "px";
			el.style.right = "auto";
		}
	};
	document.addEventListener("keyup", function(e) {
		// close on escape key.
		if (e.which === 27) {
			open = false;
			el.style.display = "none";
			clearTimeout(timershow);
		}
	});
	// don't close if mouse over popup or it's children.
	document.addEventListener("mouseover", function(e) {
		for (var p = e.target; !!p.parentNode; p = p.parentNode)
			if (p === el)
				return;
		open = false;
		el.style.display = "none";
		clearTimeout(timershow);
		return !!e.stopPropagation();
	}, false);
	document.addEventListener("mousemove", function(e) {
		if (open)
			return position(e.clientX, e.clientY);
		clearTimeout(timershow);
		timershow = setTimeout((function(target, x, y) {
			return function() {
				var uri = null;
				for (var p = target; !!p.parentNode; p = p.parentNode)
					if ((uri = p.getAttribute("data-tooltipuri")) !== null)
						break;
				if (uri === null)
					return;

				var xhr = new(XMLHttpRequest);
				xhr.open("GET", uri + ((uri.indexOf("?") != -1) ? "&" : "?") + "t=" + String(new Date().getTime()), true);
				xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
				xhr.onreadystatechange = function() {
					if (xhr.readyState != 4 || [ 0, 200 ].indexOf(xhr.status) == -1)
						return;
					el.innerHTML = xhr.responseText || "";
					el.style.display = "block";
					open = true;
					position(x, y);
				};
				xhr.timeout = 10000;
				xhr.overrideMimeType("text/html");
				xhr.send();
			};
		})(e.target, e.clientX, e.clientY), 500);
		return !!e.stopPropagation();
	}, false);
})();
