var script_loaded = {};

function script_load(uri, fn) {
	// load script once.
	if (script_loaded[uri] !== undefined)
		return;
	var script = document.createElement("script");
	script.type = "text/javascript";
	script.src = uri;
	script.async = true;
	var onload = function() {
		if (script_loaded[uri] === undefined) {
			script_loaded[uri] = true;
			fn();
		}
	};
	script.onreadystatechange = function() {
		switch (this.readyState) {
		case "complete":
		case "loaded":
			onload();
		}
	}
	script.onload = function() {
		onload();
	};
	document.getElementsByTagName("head")[0].appendChild(script);
}

// load list of uri's, fire fn() when all are loaded.
function scripts_load(uris, fn) {
	var checkfn = function() {
		for (var i = 0; i < uris.length; i++)
			if (script_loaded[uris[i]] === undefined)
				return; // not all scripts are loaded.
		fn();
	};
	for (var i = 0; i < uris.length; i++)
		script_load(uris[i], checkfn);
}
