function datalist_init(input) {
	var attrlist = input.getAttribute("list"), ellist = document.getElementById(attrlist);
	if (attrlist === null || ellist === undefined)
		return;
	input.removeAttribute("list");
	input.autocomplete = "off";
	var cursel = null, items = [], mouse = true, // enable mouse event handling.
		dropdown = document.createElement("div");
	dropdown.className = "datalist-dropdown";
	var left = 0;
	for (var c = input; c; c = c.offsetParent) {
		if (["absolute", "fixed"].indexOf(c.style.position) == -1)
			left += c.offsetLeft;
	}
	dropdown.style.left = String(left) + "px";
	dropdown.style.minWidth = String(input.clientWidth) + "px";

	for (var i = 0, ec = ellist.children; i < ec.length; i++) {
		var div = document.createElement("div");
		div.innerHTML = ec[i].innerHTML;
		div.addEventListener("mousedown", function() {
			input.value = this.textContent || this.innerText;
			datalist_show(false);
		}, false);
		div.addEventListener("mousemove", function() {
			if (mouse)
				datalist_setsel(this);
		}, false);
		items.push({ el: div, search: ((div.textContent || div.innerText).toLowerCase() || "").split(" ") });
	}

	var datalist_filter = function(data, s) {
		var matches = [], tok = s.toLowerCase().split(" ");
		for (var i = 0; i < data.length; i++) {
			var fc = 0;
			for (var k = 0; k < tok.length && fc < tok.length; k++) {
				var f = false;
				for (var j = 0; j < data[i].search.length && fc < tok.length && !f; j++)
					for (var l = 0; l < data[i].search.length && !f; l++)
						if (data[i].search[l].indexOf(tok[k]) != -1)
							f = true;
				if (f)
					fc++;
			}
			// all tokens (separated by space) must match.
			if (fc == tok.length)
				matches.push(data[i]);
		}
		return matches;
	};
	var prevmatches = [];
	var prevvalue = null;
	var datalist_match = function(s) {
		s = s.toLowerCase();
		if (s === prevvalue)
			return prevmatches;
		// if token string is different or string not in previous search: use raw data,
		// else filter on existing data and no need to sort.
		if (prevvalue === null || (prevvalue.split(" ").length != s.split(" ").length) ||
		    s.indexOf(prevvalue) == -1)
			prevmatches = datalist_filter(items, s);
		else
			prevmatches = datalist_filter(prevmatches, s);
		prevvalue = s;
		return prevmatches;
	};
	var datalist_render = function(m) {
		var dd = dropdown.cloneNode(false);
		for (var i = 0; i < m.length; i++)
			dd.appendChild(m[i].el);
		dropdown.parentNode.replaceChild(dd, dropdown)
		dropdown = dd;
	};
	var datalist_visible = false;
	var datalist_show = function(status) {
		datalist_visible = status;
		dropdown.className = "datalist-dropdown " + (status ? "visible" : "");
	};
	var datalist_setsel = function(el) {
		if (cursel)
			cursel.className = "";
		cursel = el;
		if (el)
			el.className = "sel";
	};
	input.addEventListener("keydown", function(e) {
		mouse = false;
		switch (e.which) {
		case 13: // return
			if (cursel)
				input.value = cursel.textContent || cursel.innerText;
			if (!datalist_visible)
				return datalist_show(false);
			datalist_show(false);
			e.stopPropagation();
			return !!e.preventDefault();
		case 27: break; // escape
		case 33: // page up.
		case 34: // page down.
		case 38: // arrow up
		case 40: // arrow down
			var sel = cursel, dd = dropdown, dc = dropdown.children;

			// if last and down arrow switch to first item, if first and up arrow switch to last item.
			if (dc.length) {
				if (e.which == 38) { // up
					if (!sel || !(sel = sel.previousSibling))
						sel = dc[dc.length - 1];
				} else if (e.which == 40) { // down
					if (!sel || !(sel = sel.nextSibling))
						sel = dc[0];
				} else if (!sel) {
					sel = dc[0];
				}
			}
			if (cursel && (e.which == 33 || e.which == 34)) {
				var n = sel.offsetHeight ? (dd.clientHeight / sel.offsetHeight) : 0;
				if (e.which == 33) { // page up.
					for (; n > 0 && sel && sel.previousSibling;
						n--, sel = sel.previousSibling)
						;
				} else { // page down.
					for (; n > 0 && sel && sel.nextSibling;
						n--, sel = sel.nextSibling)
						;
				}
			}
			if (sel) {
				datalist_setsel(sel);

				// only update scroll if needed.
				if (sel.offsetTop < dd.scrollTop)
					dd.scrollTop = sel.offsetTop;
				else if (sel.offsetTop + sel.offsetHeight > dd.scrollTop + dd.offsetHeight)
					dd.scrollTop = sel.offsetTop;
			}
		}
	}, false);

	var onchange = function() {
		var m = datalist_match(input.value);
		// check if selection is still active in matches.
		if (cursel) {
			var hassel = false;
			for (var i = 0; i < m.length && !(hassel = (m[i].el === cursel)); i++)
				;
			if (!hassel)
				datalist_setsel(null);
		}
		// show list if it has matches.
		if (m.length) {
			// only one match? select it.
			if (m.length == 1)
				datalist_setsel(m[0].el);
			datalist_render(m);
		}
		datalist_show(!!m.length);
	};
	var focuschange = function(e) {
		datalist_setsel(null);
		if (e.target === input) {
			var m = datalist_match(input.value);
			if (m.length)
				datalist_render(m);
			datalist_show(!!m.length);
			dropdown.scrollTop = 0; // reset scroll.
		} else {
			datalist_show(false);
		}
	};
	input.addEventListener("input", function() {
		onchange();
	});
	input.addEventListener("keyup", function(e) {
		mouse = true;
		switch (e.which) {
		case 13: // return
		case 27: // escape
			datalist_show(false);
		case 33: // page up.
		case 34: // page down.
		case 38: // arrow up
		case 40: // arrow down
			return;
		}
		onchange();
	}, false);
	input.addEventListener("focus", focuschange, false);
	document.addEventListener("click", focuschange, false);

	input.parentNode.insertBefore(dropdown, input.nextSibling);
}

var els = document.getElementsByClassName("datalist");
if (els !== null)
	for (var i = 0; i < els.length; i++)
		datalist_init(els[i]);
