if (typeof(Array) != "undefined" && typeof(Element) != "undefined" &&
    typeof(Event) != "undefined" && typeof(String) != "undefined") {
	if (!Array.prototype.indexOf)
		Array.prototype.indexOf = function(s) {
			if (!(s in this))
				return -1;
			for (var i = 0; i < this.length; i++)
				if (this[i] === s)
					return i;
			return -1;
		};
	if (!Array.prototype.map)
		Array.prototype.map = function(fn) {
			var l = [];
			for (var i = 0; i < this.length; i++)
				l.push(fn(this[i]));
			return l;
		};
	if (!document.getElementsByClassName)
		Element.prototype.getElementsByClassName = document.getElementsByClassName = function(classname) {
			var els = this.getElementsByTagName("*"), l = [],
				p = new RegExp("(^|\\s)" + classname + "(\\s|$)");
			for (var i = 0; i < els.length; i++)
				if (p.test(els[i].className))
					l.push(els[i]);
			return l;
		};
	if (!document.addEventListener)
		// NOTE: capture is ignored if addEventListener is not supported.
		if (this.attachEvent) // IE DOM
			Element.prototype.addEventListener = document.addEventListener = function(ev, fn, capture) {
				this.attachEvent("on" + ev, function(e) {
					// fixup some standard event properties.
					if (typeof(e) == "undefined")
						e = window.event;
					e.target = typeof(e.target) != "undefined" ? e.target : e.srcElement;
					e.which = typeof(e.which) != "undefined" ? e.which : e.keyCode;
					return fn.apply(this, arguments);
				});
			};
	if (!document.removeEventListener)
		if (this.detachEvent) // IE DOM
			Element.prototype.removeEventListener = document.removeEventListener = function(ev, fn, capture) {
				this.detachEvent("on" + ev, fn);
			};
	if (!Event.prototype.stopPropagation)
		Event.prototype.stopPropagation = function() {
			 window.event.cancelBubble = true;
			 return false;
		};
	if (!String.trim)
		String.prototype.trim = function() {
			return this.replace(/^\s+|\s+$/g, "");
		};
}
