#ifndef __OpenBSD__
#define pledge(p1,p2) 0
#define unveil(p1,p2) 0
#endif

/* ctype-like macros, but always compatible with ASCII / UTF-8 */
#define ISALPHA(c) ((((unsigned)c) | 32) - 'a' < 26)
#define ISCNTRL(c) ((c) < ' ' || (c) == 0x7f)
#define ISDIGIT(c) (((unsigned)c) - '0' < 10)
#define ISSPACE(c) ((c) == ' ' || ((((unsigned)c) - '\t') < 5))
#define TOLOWER(c) ((((unsigned)c) - 'A' < 26) ? ((c) | 32) : (c))

#undef strlcat
size_t strlcat(char *, const char *, size_t);
#undef strlcpy
size_t strlcpy(char *, const char *, size_t);

int decodeparam(char *buf, size_t bufsiz, const char *s);
int durationstr(long secs, char *buf, size_t bufsiz);
int friendlytime(time_t now, time_t t);
char *getparam(const char *query, const char *s);
void gophertext(FILE *fp, const char *s, size_t len);
int hexdigit(int c);
size_t printnumsep(const char *s);
int uriencode(const char *s, char *buf, size_t bufsiz);
int utf8pad(char *buf, size_t bufsiz, const char *s, size_t len, int pad);
void xmlencode(const char *s);
