struct item {
	enum LinkType { Unknown = 0, Channel, Movie, Playlist, Video } linktype;
	char id[32];
	char title[1024];
	char channeltitle[1024];
	char channelid[256];
	char userid[256];
	char publishedat[32]; /* "human-friendly" string */
	char viewcount[32]; /* view count string, formatted */
	char duration[32]; /* duration string */
	char shortdescription[4096];
};

#define MAX_VIDEOS 50
struct search_response {
	struct item items[MAX_VIDEOS + 1];
	size_t nitems;
};

struct video_format {
	long itag;
	char url[2048];
	char signaturecipher[2048]; /* encrypted stream */
	char mimetype[256]; /* mime-type and video codecs, etc */
	long bitrate;
	long averagebitrate;
	long width; /* pixel width */
	long height; /* pixel width */
	long fps; /* frames-per-second */
	char qualitylabel[64];
	char quality[64];
	long long contentlength; /* content length in bytes */
	long lastmodified; /* timestamp */
	long audiosamplerate;
	long audiochannels;
};

#define MAX_FORMATS 50
struct video_response {
	char id[32]; /* video id */
	char title[1024];
	char author[1024]; /* channel name / title */
	char channelid[256];
	char publishdate[32]; /* YYYY-mm-dd */
	char uploaddate[32]; /* YYYY-mm-dd */
	long viewcount;
	long lengthseconds;
	char shortdescription[4096 * 4];
	char category[256];
	int isfamilysafe;
	int isunlisted;

	int isfound;

	/* expiration for URLs in video formats */
	long expiresinseconds;
	struct video_format formats[MAX_FORMATS + 1];
	int nformats;
};

struct search_response *youtube_search(const char *rawsearch, const char *page, const char *order);
struct search_response *youtube_channel_videos(const char *channelid);
struct search_response *youtube_user_videos(const char *user);
struct video_response *youtube_video(const char *videoid);
