#ifndef _JSON_H_
#define _JSON_H_

#include <stddef.h>

enum JSONType {
	JSON_TYPE_ARRAY  = 'a',
	JSON_TYPE_OBJECT = 'o',
	JSON_TYPE_STRING = 's',
	JSON_TYPE_BOOL   = 'b',
	JSON_TYPE_NULL   = '?',
	JSON_TYPE_NUMBER = 'n'
};

enum JSONError {
	JSON_ERROR_MEM     = -2,
	JSON_ERROR_INVALID = -1
};

#define JSON_MAX_NODE_DEPTH 64

struct json_node {
	enum JSONType type;
	char *name;
	size_t namesiz;
	size_t index; /* count/index for array or object type */
};

int parsejson(const char *, size_t,
              void (*cb)(struct json_node *, size_t, const char *, size_t, void *),
              void *);
#endif
