#include <sys/types.h>

#include <ctype.h>
#include <err.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <wchar.h>

#include "duckduckgo.h"
#include "util.h"

#define OUT(s) fputs((s), stdout)
#define OUTESCAPE(s) printescape((s))

/* print: ignore control-characters */
void
printescape(const char *s)
{
	for (; *s; ++s)
		if (!iscntrl((unsigned char)*s))
			fputc(*s, stdout);
}

int
main(int argc, char *argv[])
{
	struct duckduckgo_results *results;
	struct duckduckgo_result *result;
	char buf[512];
	size_t i;

	setlocale(LC_CTYPE, "");

	if (pledge("stdio", NULL) == -1)
		err(1, "pledge");

	if (argc != 2) {
		fprintf(stderr, "usage: %s <search>\n", argv[0]);
		exit(1);
	}

	if ((results = duckduckgo_search(argv[1]))) {
		for (i = 0; i < results->nitems; i++) {
			result = &(results->items[i]);

			if (utf8pad(buf, sizeof(buf), result->title, 70, ' ') != -1)
				OUTESCAPE(buf);
			OUT("  ");
			OUTESCAPE(result->urldecoded);
			OUT("\n");
		}
	}

	return 0;
}
