struct item {
	char name[16];
	char title[1024];
	char url[4096];
	char permalink[4096];
	char subreddit[256];
	char author[256];
	char thumbnail[4096];
	long ups;
	long downs;
	time_t created_utc;
	struct tm created_tm;
	int is_video;
	long num_comments;
	long duration;
	char dash_url[4096];
	/* flair */
	char link_flair_text[256];
	char link_flair_background_color[8];
};

/* Reddit supports max 100 items in their API */
#define MAX_ITEMS 100

struct list_response {
	struct item items[MAX_ITEMS + 1];
	size_t nitems;
	/* tokens */
	char before[256];
	char after[256];
};

struct list_response *reddit_list(const char *subreddit, int limit,
	const char *before, const char *after);

int reddit_isvalidlink(const char *s);
