struct game {
	char id[16];
	char name[256];
	// char box_art_url[256];
};

struct stream {
	char id[16];
	char user_id[16];
	char user_name[256];
	char game_id[16];
//	char type[32];
	char title[256];
	long long viewer_count;
//	char started_at[24];
	char language[8];
//	char thumbnail_url[256];

	/* added (not part of API) */
	struct game *game; /* will be set if matched and not a specific game */
	struct user *user; /* will be set if matched */
};

struct user {
	char id[16];
	char login[256];
	char display_name[256];
//	char broadcaster_type[256]; /* "partner" */
//	char description[256];
//	char profile_image_url[256];
//	char offline_image_url[256];
	long long view_count;
};

struct video {
	char id[16];
	char user_id[16];
	char user_name[64];
	char title[256];
	char created_at[32];
	char url[1024];
	long long view_count;
	char duration[32];
};

#define MAX_ITEMS 100

struct games_response {
	struct game data[MAX_ITEMS + 1];
	size_t nitems;
//	char pagination[256];
};

struct streams_response {
	struct stream data[MAX_ITEMS + 1];
	size_t nitems;
//	char pagination[256];
};

struct users_response {
	struct user data[MAX_ITEMS + 1];
	size_t nitems;
};

struct videos_response {
	struct video data[MAX_ITEMS + 1];
	size_t nitems;
//	char pagination[256];
};

struct games_response    *twitch_games_bygameids(const char *param);
struct games_response    *twitch_games_top(void);
struct streams_response  *twitch_streams(void);
struct streams_response  *twitch_streams_bygame(const char *game_id);
struct users_response    *twitch_users_bylogin(const char *login);
struct users_response    *twitch_users_byuserids(const char *param);
struct videos_response   *twitch_videos_byuserid(const char *user_id);

struct games_response    *twitch_streams_games(struct streams_response *r);
struct users_response    *twitch_streams_users(struct streams_response *r);
