#include <sys/types.h>

#include <ctype.h>
#include <err.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <wchar.h>

#include "duckduckgo.h"
#include "util.h"

#define OUT(s) fputs(s, stdout)
#define OUTTEXT(s) gophertext(stdout, s, strlen(s))

static const char *host = "127.0.0.1", *port = "70";

int
main(void)
{
	struct duckduckgo_results *results;
	struct duckduckgo_result *result;
	char buf[512], *p, *search = NULL;
	size_t i;

	setlocale(LC_CTYPE, "");

	if ((p = getenv("SERVER_NAME")))
		host = p;
	if ((p = getenv("SERVER_PORT")))
		port = p;
	if ((p = getenv("X_GOPHER_SEARCH")))
		search = p;

	if (pledge("stdio", NULL) == -1)
		err(1, "pledge");

	if (search == NULL) {
		printf("3\tSpecify a search term\t%s\t%s\r\n", host, port);
		printf(".\r\n");
		exit(1);
	}

	if ((results = duckduckgo_search(search))) {
		for (i = 0; i < results->nitems; i++) {
			result = &(results->items[i]);

			OUT("h");
			OUTTEXT(result->title);
			OUT("\tURL:");
			OUTTEXT(result->urldecoded);
			printf("\t%s\t%s\r\n", host, port);

			/* TODO: multi-line wrap ? */
			OUT("h");
			OUTTEXT(result->description);
			OUT("\tURL:");
			OUTTEXT(result->urldecoded);
			printf("\t%s\t%s\r\n", host, port);

			printf("i\t\t%s\t%s\r\n", host, port);
			printf("i\t\t%s\t%s\r\n", host, port);
		}
	}
	printf(".\r\n");

	return 0;
}
