#include <genesis.h>
#include "common.h"
#include "database.h"
#include "joy.h"
#include "resources.h"
#include "resources_snd.h"
#include "sound.h"

#define NASU_SAVE_OFFSET			0
#define BONUS_CHANCE				50
#define BONUS_CHANCE_TIME			20
#define DEFAULT_SCORE_GFX_TIMEOUT	30
#define MENU_TEXT_ATTR				57344	// TILE_ATTR(PAL3, 1, 0, 0)

enum {NS_TITLE, NS_READY, NS_INGAME, NS_LOSE, NS_GAMEOVER};
enum {NASU_STAND, NASU_WALK, NASU_JUMP};

bool codes_update(u8 *code_activated);

void nasu() {
	struct item {
		Sprite *sprite;
		u8 x, y, yspeed;
		u8 score;
	};

	struct nasu {
		Sprite *sprite;
		u8 x, y;
		u8 state, direction;
	};

	u8 nasu_state = NS_TITLE;
	u8 nasu_timer = 0;
	u8 spawn_timer = 0;
	u8 bounce_timer = 0;
	u8 bonus_timer = 0;
	u8 code_activated = 0;
	u8 score_gfx_timer = 0;
	u8 score_gfx_timeout = DEFAULT_SCORE_GFX_TIMEOUT;

	u16 hiscore = 0;
	u16 score = 0;
	fix16 yspeed;
	bool drawn = false;
	bool cheat = false;
	bool spawn_bonus_eggplant = false;
	char score_text[6] = "000000";

	struct nasu nasu = { NULL, 0, 0, NASU_STAND, 0 };
	struct item eggplant = { NULL, 0, 0, 0, 1 };
	struct item bonus_eggplant = { NULL, 0, 0, 0, 30 };
	struct item scoregfx = { NULL, 0, 0, 0, 0 };
	struct item *eggplants[2] = {&eggplant, &bonus_eggplant};

	SRAM_enableRO();
	hiscore = SRAM_readWord(NASU_SAVE_OFFSET);
	SRAM_disable();

	// Necessary for some emulators
	if (hiscore == MAX_U16)
		hiscore = 0;

	joy_reset();
	PAL_setPalette(PAL0, pal_nasu.data, DMA_QUEUE_COPY);
	PAL_setPalette(PAL3, pal_window_1.data, DMA_QUEUE_COPY);
	VDP_loadFont(&til_nasu_font, DMA);

	// This is used to draw text on top of the field with a green background
	PAL_setPalette(PAL1, pal_window_1.data, DMA);
	PAL_setColor(0x11, 0x040);

	VDP_loadTileSet(&til_nasu, TILE_MAP_INDEX, DMA_QUEUE_COPY);
	VDP_setTileMapEx(BG_A, &tmp_nasu_frame, 
			TILE_ATTR_FULL(PAL3, 0, 0, 0, TILE_WINDOW_INDEX), 8, 5, 0, 0, 
			24, 18, DMA_QUEUE_COPY);

	while (1) {
		if (nasu_state == NS_TITLE) {
			if (!drawn) {
				XGM2_play(bgm_NasuTitle);

				//Draw the title
				intToStr(hiscore, score_text, 4);
				VDP_setTileMapEx(BG_A, &tmp_nasu_title, 
						TILE_ATTR_FULL(PAL0, 0, 0, 0, TILE_MAP_INDEX),
						9, 6, 0, 0, 22, 16, DMA_QUEUE_COPY);
				VDP_drawTextEx(BG_A, "PUSH START", 
						MENU_TEXT_ATTR, 15, 16, DMA_QUEUE_COPY);
				VDP_drawTextEx(BG_A, "HI-SCORE 00000", 
						MENU_TEXT_ATTR, 13, 18, DMA_QUEUE_COPY);
				VDP_drawTextEx(BG_A, score_text, 
						MENU_TEXT_ATTR, 22, 18, DMA_QUEUE_COPY);
				drawn = true;
			}

			cheat = codes_update(&code_activated);

			if(joy_pressed(BUTTON_START)) {
				nasu_state = NS_READY;
				drawn = false;
			}
		} else if (nasu_state == NS_READY) {
			//Draw ready screen
			XGM2_stop();
			VDP_clearTileMapRect(BG_A, 9, 6, 22, 16);
			VDP_drawText("READY", 17, 13);
			waitTick(2 * 300);
			nasu_state = NS_INGAME;
		} else if (nasu_state == NS_INGAME) {
			if (!drawn) {
				XGM2_play(bgm_NasuInGame);

				// Draw game screen
				VDP_setTileMapEx(BG_A, &tmp_nasu_stage, 
						TILE_ATTR_FULL(PAL0, 0, 0, 0, TILE_MAP_INDEX), 
						9, 6, 0, 0, 22, 16, DMA_QUEUE_COPY);
				VDP_drawTextEx(BG_A, "START", 
						MENU_TEXT_ATTR, 17, 13, DMA_QUEUE_COPY);
				VDP_drawTextEx(BG_A, "SCORE 00000", 
						TILE_ATTR(PAL1, 1, 0, 0), 20, 21, DMA_QUEUE_COPY);

				// Player initialisation
				nasu.x = 19 * 8;
				nasu.y = 17 * 8;
				nasu.sprite = SPR_addSprite(&spr_nasu, nasu.x, nasu.y,
						TILE_ATTR(PAL0,1,0,0));
				SPR_setPosition(nasu.sprite, nasu.x, nasu.y);
				SPR_setAnim(nasu.sprite, 3 * cheat);
				SPR_update();

				waitTick(2 * 300);

				// Draw the screen again
				VDP_setTileMapEx(BG_A, &tmp_nasu_stage, 
						TILE_ATTR_FULL(PAL0, 0, 0, 0, TILE_MAP_INDEX),
						9, 6, 0, 0, 22, 16, DMA_QUEUE_COPY);
				VDP_drawTextEx(BG_A, "SCORE 00000", 
						TILE_ATTR(PAL1, 1, 0, 0), 20, 21, DMA_QUEUE_COPY);

				drawn = true;
			} else {
				nasu_timer++;
				spawn_timer++;
				
				if (bonus_timer) {
					bonus_timer--;
				}

				// Draw score
				intToStr(score, score_text, 4);
				VDP_drawTextEx(BG_A, score_text, 
						TILE_ATTR(PAL1, 1, 0, 0), 26, 21, DMA_QUEUE_COPY);

				if (scoregfx.sprite 
						&& score_gfx_timer++ == score_gfx_timeout) {
					score_gfx_timeout = DEFAULT_SCORE_GFX_TIMEOUT;
					SPR_safeRelease(scoregfx.sprite);
				}

				// Handle Nasu's movement, do not allow him to go out of bounds
				s8 move = !!joy_down(BUTTON_RIGHT) - !!joy_down(BUTTON_LEFT);
				if (move) {
					if ((move < 0 && nasu.x > 9 * 8) 
							|| (move > 0 && nasu.x < 29 * 8)) {
						SPR_setHFlip(nasu.sprite, move < 0);
						nasu.x += move;
						if (nasu.state != NASU_JUMP)
							nasu.state = NASU_WALK;
						if (nasu_timer % 15 == 0 && nasu.state == NASU_WALK)
							sound_play_ch(SFX_NASU_WALK, 2);
					} else if (nasu.state != NASU_JUMP) {
						yspeed = 0;
						nasu.state = NASU_STAND;
					}
				} 

				// If Nasu's on the floor or landing
				if (nasu.y >= 17 * 8) {
					if ((nasu.state == NASU_WALK && !move) 
							|| nasu.state == NASU_JUMP){
						yspeed = 0;
						sound_play_ch(SFX_NASU_WALK, 2);
						nasu.y = 17 * 8;
						nasu.state = NASU_STAND;
					}
				}

				// Make Nasu jump if he's on the floor
				if ((joy_pressed(BUTTON_A) 
							|| joy_pressed(BUTTON_B) 
							|| joy_pressed(BUTTON_C))
						&& nasu.state != NASU_JUMP 
						&& nasu.y >= 17 * 8) {
					yspeed = 3;
					nasu_timer = 0;
					nasu.state = NASU_JUMP;
					sound_play_ch(SFX_NASU_JUMP, 2);
				}

				if (nasu.state == NASU_JUMP) {
					nasu.y -= yspeed;
					yspeed -= (nasu_timer % 4 == 0);
					// Eat eggplants
					for (u8 i = 0; i < 2; i++) {
						if (!(eggplants[i]->y >= nasu.y + 4
							&& eggplants[i]->y <= nasu.y + 8
							&& eggplants[i]->x >= nasu.x - 2
							&& eggplants[i]->x <= nasu.x + 8))
							continue;

						SPR_safeRelease(scoregfx.sprite);
						scoregfx.sprite = SPR_addSprite(&spr_nasu_score,
								eggplants[i]->x, eggplants[i]->y,
								TILE_ATTR(PAL0, 1, 0, 0));

						// If another eggplant was eaten recently: bonus
						if (bonus_timer) {
							sound_play_ch(SFX_NASU_BONUS, 1);
							bonus_timer = 0;
							score_gfx_timeout = 90;

							SPR_setPosition(scoregfx.sprite,
								18 * 8-4, 14 * 8);
							SPR_setAnim(scoregfx.sprite, 2);

							if (score <= 9999 - 100)
								score += 100;
							else
								score = 9999; 
						} else {
							sound_play_ch(SFX_NASU_GET, 1);
							bonus_timer = BONUS_CHANCE_TIME;

							SPR_setPosition(scoregfx.sprite,
									eggplants[i]->x - 8,
									eggplants[i]->y);
							SPR_setAnim(scoregfx.sprite, i);

							if (score <= 9999 - eggplants[i]->score)
								score += eggplants[i]->score;
							else
								score = 9999;
						}

						// Normal eggplants have a chance to spawn bonus ones
						if (i == 0 && !bonus_eggplant.sprite &&
								(cheat || !(random() % BONUS_CHANCE)))
							spawn_bonus_eggplant = TRUE;

						SPR_safeRelease(eggplants[i]->sprite);
						score_gfx_timer = 0;
						eggplants[i]->x = 0;
						eggplants[i]->y = 0;
						eggplants[i]->yspeed = 0;

						if (i == 1) 
							bounce_timer = 0;
					}
				}

				// Spawn eggplants
				if (spawn_timer % 120 == 0) {
					eggplant.x = ((random() % 22) + 9) * 8;
					eggplant.y = 5 * 8;
					eggplant.sprite = SPR_addSprite(&spr_nasu_item,
							eggplant.x, eggplant.y,
							TILE_ATTR(PAL0, 1, 0, 0));
					spawn_timer = 0;
				}

				if (spawn_bonus_eggplant) {
					spawn_bonus_eggplant = false;
					bounce_timer = 0;
					bonus_eggplant.x = 9 * 8;
					bonus_eggplant.y = 17 * 8;
					bonus_eggplant.sprite = SPR_addSprite(&spr_nasu_item,
							bonus_eggplant.x, bonus_eggplant.y,
							TILE_ATTR(PAL0, 1, 0, 0));
				}

				// If an eggplant hits the floor, it's game over
				if (eggplant.y >= 19 * 8) {
					nasu_state = NS_LOSE;
					XGM2_stop();
					sound_play(SFX_NASU_MISS);
				} else {
					eggplant.y++;
				}

				// Update sprites' positions
				if (eggplant.sprite) {
					SPR_setPosition(eggplant.sprite,
							eggplant.x, eggplant.y);
					SPR_setAnim(eggplant.sprite, 0);
				}

				// Bonus eggplant movement
				if (bonus_eggplant.sprite) {
					if (bonus_eggplant.x >= 30 * 8) {
						SPR_safeRelease(bonus_eggplant.sprite);
						bounce_timer = 0;
						bonus_eggplant.x = 0;
						bonus_eggplant.y = 0;
					} else if (bonus_eggplant.y >= 19 * 8) {
						bounce_timer = 0;
						bonus_eggplant.yspeed = 2;
						bonus_eggplant.y = 19 * 8;
					}

					bounce_timer++;
					bonus_eggplant.x += (bounce_timer % 4 == 0);
					bonus_eggplant.y -= bonus_eggplant.yspeed;
					bonus_eggplant.yspeed -= (bounce_timer % 8 == 0);

					if (bonus_eggplant.sprite) {
						SPR_setPosition(bonus_eggplant.sprite,
							bonus_eggplant.x, bonus_eggplant.y);
						SPR_setAnim(bonus_eggplant.sprite, 1);
					}
				}

				SPR_setPosition(nasu.sprite, nasu.x, nasu.y);
				SPR_setAnim(nasu.sprite, nasu.state + 3*cheat);
			}
		} else if (nasu_state == NS_LOSE) {
			u8 pal = 1;

			for (u8 i = 0; i < 11; i++) {
				PAL_setPalette(PAL0, 
						pal ? pal_nasu_lose.data : pal_nasu.data, DMA_QUEUE);
				pal = !pal;
				waitTick(25);
			}

			waitTick(1 * 300);

			SPR_safeRelease(bonus_eggplant.sprite);
			nasu_state = NS_GAMEOVER;
		} else if (nasu_state == NS_GAMEOVER) {
			SPR_safeRelease(eggplant.sprite);
			SPR_safeRelease(nasu.sprite);
			SPR_safeRelease(scoregfx.sprite);
			SPR_update();


			//Draw game over screen
			VDP_clearTileMapRect(BG_A, 9, 6, 22, 16);
			PAL_setPalette(PAL0, pal_nasu.data, DMA);
			VDP_drawText("SCORE 00000", 20, 21);
			VDP_drawText(score_text, 26, 21);
			VDP_drawText("GAME  OVER", 15, 13);
			XGM2_play(bgm_NasuGameOver);

			// Reset variables
			nasu_timer = 0;
			spawn_timer = 0;
			bonus_timer = 0;
			score = 0;
			eggplant.x = 0;
			eggplant.y = 0;
			bonus_eggplant.x = 0;
			bonus_eggplant.y = 0;
			score_gfx_timer = 0;
			score_gfx_timeout = DEFAULT_SCORE_GFX_TIMEOUT;
			drawn = false;

			// If the cheat is enabled, high scores are not saved
			if (!cheat) {
				if (score > hiscore) 
					hiscore = score;
				SRAM_enable();
				SRAM_writeWord(NASU_SAVE_OFFSET, hiscore);
				SRAM_disable();
			}

			waitTick(6 * 300);
			nasu_state = NS_TITLE;
		}
		joy_update();
		SPR_update();
		SYS_doVBlankProcess();
	}
}

#define CODE_CASE(btn) { \
	if (joy_pressed(btn)) (*code_activated)++; \
	else *code_activated = 0; \
	break; \
}

bool codes_update(u8 *code_activated) {
	if (*code_activated == 10)
		return TRUE;
	if ((joystate | oldstate) == oldstate)
		return FALSE;

	switch (*code_activated) {
		case 0: CODE_CASE(BUTTON_LEFT)
		case 1: CODE_CASE(BUTTON_LEFT)
		case 2: CODE_CASE(BUTTON_RIGHT)
		case 3: CODE_CASE(BUTTON_RIGHT)
		case 4: CODE_CASE(BUTTON_UP)
		case 5: CODE_CASE(BUTTON_DOWN)
		case 6: CODE_CASE(BUTTON_UP)
		case 7: CODE_CASE(BUTTON_DOWN)
	}

	if (*code_activated == 8) {
		*code_activated = 10;
		sound_play(SFX_CHOICE);
		return TRUE;
	}

	return FALSE;
}
