#include <genesis.h>
#include "common.h"
#include "sound.h"
#include "resources.h"
#include "resources_snd.h"
#include "database.h"
#include "menu.h"
#include "joy.h"

#define MENU_TEXT_ATTR	57344	// TILE_ATTR(PAL3, 1, 0, 0)

u8 menu_state = MS_CLOSED;

void menu_splash() {
	u8 frame = 0;
    u16 pal[64] = { 0 };
	game_state = GSTATE_SPLASH;
	memcpy(&pal[0], pal_sega.data, 16 * 2);

	PAL_setColors(0, pal, 15, DMA);
	VDP_loadTileSet(&til_sega, TILE_MAP_INDEX, DMA);
	VDP_setTileMapEx(BG_A, &tmp_sega, 
		TILE_ATTR_FULL(PAL0, TRUE, FALSE, FALSE, TILE_MAP_INDEX),
		14, 12, 0, 0, 12, 4, DMA_QUEUE);

	while (1) {
		game_timer++;
		if (game_timer % 4 == 0) {
			if (frame < 9)
				memcpy(&pal[0], pal_sega.data + 1 + frame, (9 - frame) * 2);

			if (frame < 10)
				memcpy(&pal[9 - frame], pal_sega_inv.data + 1, 7 * 2);
			else
				memcpy(&pal[0], pal_sega_inv.data + frame - 8,
						(-frame + 16) * 2);
			
			if (frame > 6)
				memcpy(&pal[16 - frame], pal_sega.data + 1, (frame - 6) * 2);

			PAL_setColors(1, pal, 9, DMA_QUEUE);
			if (++frame == 16)
				frame = 0;
		}
		if (joy_pressed(BUTTON_A) 
				|| joy_pressed(BUTTON_B)
				|| joy_pressed(BUTTON_C)
				|| joy_pressed(BUTTON_START)
				|| game_timer == 60 * 5) {
			break;
		}
		joy_update();
		SPR_update();
		SYS_doVBlankProcess();
	}
	PAL_fadeOutAll(10, FALSE);
}

