#include <genesis.h>
#include "common.h"
#include "joy.h"

u16 joystate = 0;
u16 oldstate = 0;
u16 joyoverride = 0;
u8 joytimer = 0;

void joy_reset() {
	joystate = 0;
	oldstate = 0;
	joyoverride = 0;
	joytimer = 0;
}

void joy_update() {
	oldstate = joystate;
	joystate = joyoverride? joyoverride : JOY_readJoypad(JOY_1);
	if (joytimer > 0 ) { joytimer--; if (!joytimer) joyoverride = 0; }
}

void joy_press_frames(u16 button, u8 frames) {
	joytimer = frames;
	joyoverride = button;
}
