#ifndef MENU_H
#define MENU_H

#define MENU_ROWS			2
#define MAX_EFFECT_ROWS		12
#define EFFECT_COLUMNS		2
#define MAX_EFFECTS_PAGE	MAX_EFFECT_ROWS * EFFECT_COLUMNS
#define QUICK_PRESS_WAIT	14
#define QUICK_PRESS_RESET	10
#define DEFAULT_FADE_TIME	5

#define SAVE_DATA_LENGTH	36

enum {
	MS_CLOSED,
	MS_STATS,
	MS_EFFECTS,
	MS_QUIT,
	MS_MAIN,
	MS_LOADSAVE,
	MS_DIALOG
};

extern u8 menu_state;

u8 menu_update();
void menu_splash();
void menu_main();
void menu_loadsave();
void menu_stats();
void menu_effects(u8 cursor_y);
void menu_effect_dialog(u8 effect);
void menu_instructions();
void menu_quit();
void menu_close(u8 time);
void set_cursor_position();
void update_effect_description();
void menu_fade_transition(bool out, bool back_to_game, u8 time);

void nasu();

typedef struct {
	Sprite* sprite_l;
	Sprite* sprite_r;
	u8 x, y, last_y, data;
} Cursor;

#endif // MENU_H
