#ifndef COMMON_H
#define COMMON_H

#define YN_DEBUG

#define SCREEN_W			320
#define SCREEN_H			224
#define SCREEN_H_LOOP		256
#define SCREEN_HALF_W		(SCREEN_W >> 1)
#define SCREEN_HALF_H		(SCREEN_H >> 1)
#define SCREEN_HALF_H_LOOP	(SCREEN_H_LOOP >> 1)
#define SCREEN_DEACT_W		32	//24
#define SCREEN_DEACT_H		48	//32
#define BLOCK_SIZE			16
#define WALK_SPEED			1
#define RUN_SPEED			2

#define TILE_WINDOW_INDEX	TILE_USER_INDEX
#define TILE_WINDOW_LENGTH	25
#define TILE_MAP_INDEX		TILE_WINDOW_INDEX + TILE_WINDOW_LENGTH
#define TILE_BLACK			(TILE_MAP_INDEX - 1)
#define TILE_PLAYER_INDEX	1

#define SPR_safeRelease(sprite) \
	if (sprite) { \
		SPR_releaseSprite(sprite); \
		sprite = NULL; \
	}

enum {
	STATE_STAND, STATE_CHAIR, STATE_WALK, STATE_WARP,
	STATE_ANIM, STATE_ANIM_FINISHED,
	STATE_DIE, STATE_DISABLED, STATE_INACTIVE
};

enum {
	GSTATE_SPLASH, GSTATE_MAINMENU, GSTATE_INGAME, GSTATE_MENU,
	GSTATE_NASU, GSTATE_CUTSCENE, GSTATE_INSTRUCTIONS,
};

enum {
	DIR_UP, DIR_RIGHT, DIR_DOWN, DIR_LEFT, DIR_NONE
};

typedef struct
{
	s16 x, y, width, height;
} Area;

typedef struct
{
	Area;
	u8 aid;
} AreaEx;

typedef struct {
	s16 x, y;
	u8 eid;	// For database lookups. Multiple entities can share the same eid
	u8 warpid;
} EntityBase;

// Forward
typedef struct Entity_ Entity;
typedef void (*EntityFunction)(Entity*);

extern u16 current_ind, current_spr_ind;
extern u16 game_timer;
extern u8 game_state;

extern Sprite* spotlight;

#endif // COMMON_H
