﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Windows.Forms;

namespace ItemEditor {
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            MaximizeBox = false;
            FormBorderStyle = FormBorderStyle.FixedSingle;
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void label7_Click(object sender, EventArgs e)
        {

        }

        private void label9_Click(object sender, EventArgs e)
        {

        }

        private void UpdateBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Clipboard.SetText(item_text.Text);
            }
            catch (Exception)
            {
                MessageBox.Show(@"There is nothing to copy.", @"Whoopsie!", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
            }
        }

        private void item_fire_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_name_TextChanged(object sender, EventArgs e)
        {
            /*char[] vowels = { 'A', 'E', 'I', 'O', 'U' };
            
            foreach (char vowel in vowels) {
                if (item_name.Text.ToUpper().StartsWith(Convert.ToString(vowel))) {
                    item_article.Text = "an";
                    break;
                }
                else
                {
                    item_article.Text = "a";
                }
            }*/

            update();
        }

        private void item_import_Click(object sender, EventArgs e)
        {
            try
            {
                var entries = item_text.Text.Split(new[] { "\n", "\r\n" }, StringSplitOptions.RemoveEmptyEntries);

                for (var i = 0; i < entries.Length; i++)
                {
                    entries[i] = entries[i].Substring(21).Replace("\"", "");
                }

                item_id.Text = entries[0];
                item_name.Text = entries[1];
                item_description.Text = entries[2];
                item_effect.Text = entries[3];
                item_equippable.SelectedIndex = Convert.ToInt32(entries[4]);
                item_equip_target.SelectedIndex = Convert.ToInt32(entries[5])+1;
                item_off.Value = Convert.ToDecimal(entries[6]);
                item_def.Value = Convert.ToDecimal(entries[7]);
                item_guts.Value = Convert.ToDecimal(entries[8]);
                item_speed.Value = Convert.ToDecimal(entries[9]);
                item_target.SelectedIndex = Convert.ToInt32(entries[10])+1;
                item_fire.Value = Convert.ToDecimal(entries[11]);
                item_freeze.Value = Convert.ToDecimal(entries[12]);
                item_thunder.Value = Convert.ToDecimal(entries[13]);
                item_hypnosis.Value = Convert.ToDecimal(entries[14]);
                item_paralysis.Value = Convert.ToDecimal(entries[15]);
                item_flash.Value = Convert.ToDecimal(entries[16]);
                item_article.Text = entries[17].Replace(" ", "");
                item_sellable.Checked = entries[18].Equals("1");
                item_price.Value = Convert.ToDecimal(entries[19]);
                item_iq.Value = Convert.ToDecimal(entries[20]);
                item_hp.Value = Convert.ToDecimal(entries[21]);
                item_pp.Value = Convert.ToDecimal(entries[22]);
                item_status.SelectedIndex = Convert.ToInt32(entries[23]);

                update();
            }
            catch (Exception)
            {
                MessageBox.Show(@"Error while importing.
The formatting may be incorrect. Fix it and try again.",@"Whoopsie!",MessageBoxButtons.OK,MessageBoxIcon.Asterisk,MessageBoxDefaultButton.Button1);
            }
        }

        private void update()
        {
            var space = "   ";
            if (item_id.Value > 9 && item_id.Value < 100)
            {
                space = "  ";
            }
            else if (item_id.Value > 99)
            {
                space = " ";
            }

            item_text.Text = "global.item[" + item_id.Value + ",0] =" + space + item_id.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",1] =" + space + "\"" + item_name.Text + "\"" + Environment.NewLine
                + "global.item[" + item_id.Value + ",2] =" + space + "\"" + item_description.Text + "\"" + Environment.NewLine
                + "global.item[" + item_id.Value + ",3] =" + space + "\"" + item_effect.Text + "\"" + Environment.NewLine
                + "global.item[" + item_id.Value + ",4] =" + space + item_equippable.SelectedIndex + Environment.NewLine
                + "global.item[" + item_id.Value + ",5] =" + space + (item_equip_target.SelectedIndex-1) + Environment.NewLine
                + "global.item[" + item_id.Value + ",6] =" + space + item_off.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",7] =" + space + item_def.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",8] =" + space + item_guts.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",9] =" + space + item_speed.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",10]=" + space + (item_target.SelectedIndex - 1) + Environment.NewLine
                + "global.item[" + item_id.Value + ",11]=" + space + item_fire.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",12]=" + space + item_freeze.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",13]=" + space + item_thunder.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",14]=" + space + item_hypnosis.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",15]=" + space + item_paralysis.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",16]=" + space + item_flash.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",17]=" + space + "\"" + item_article.Text + " \"" + Environment.NewLine
                + "global.item[" + item_id.Value + ",18]=" + space + Convert.ToByte(item_sellable.Checked) + Environment.NewLine
                + "global.item[" + item_id.Value + ",19]=" + space + item_price.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",20]=" + space + item_iq.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",21]=" + space + item_hp.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",22]=" + space + item_pp.Value + Environment.NewLine
                + "global.item[" + item_id.Value + ",23]=" + space + item_status.SelectedIndex;
        }

        private void button1_Click(object sender, EventArgs e) {
            OpenFileDialog theDialog = new OpenFileDialog();
            theDialog.Title = "Open script file";
            theDialog.Filter = "GML script|*.gml";
            theDialog.InitialDirectory = @"D:\";
            itemGrid.Rows.Clear();
            try {
                if (theDialog.ShowDialog() != DialogResult.OK) return;

                var filename = theDialog.FileName;
                var filelines = File.ReadAllLines(filename).Where(arg => !string.IsNullOrWhiteSpace(arg));

                var linesPerItem = 24;
                var currItemLine = 1;
                var item = new GameItem();
                var gameItems = new List<GameItem>();
                var enumerable = filelines as string[] ?? filelines.ToArray();
                for (var i = 0; i < enumerable.Length; i++) {
                    if (enumerable[i].StartsWith("/*") || enumerable[i].StartsWith("//") || enumerable[i].StartsWith("*/") || enumerable[i].Equals(""))
                        continue;
                    enumerable[i] = enumerable[i].Substring(21).Replace("\"", "");
                }
            
                for (var i = 0; i < enumerable.Length; i++) {

                    if (enumerable[i].StartsWith("/*") || enumerable[i].StartsWith("//") ||
                        enumerable[i].StartsWith("*/"))
                        continue;

                    switch (currItemLine) {
                        case 1:
                            item.Id = Convert.ToInt32(enumerable[i]);
                            break;
                        case 2:
                            item.Name = enumerable[i];
                            break;
                        case 3:
                            item.Desc = enumerable[i];
                            break;
                        case 4:
                            item.Effect = enumerable[i];
                            break;
                        case 5:
                            item.Equippable = Convert.ToInt32(enumerable[i]);
                            break;
                        case 6:
                            item.EquipWho = Convert.ToInt32(enumerable[i]);
                            break;
                        case 7:
                            item.Off = Convert.ToInt32(enumerable[i]);
                            break;
                        case 8:
                            item.Def = Convert.ToInt32(enumerable[i]);
                            break;
                        case 9:
                            item.Guts = Convert.ToInt32(enumerable[i]);
                            break;
                        case 10:
                            item.Speed = Convert.ToInt32(enumerable[i]);
                            break;
                        case 11:
                            item.Target = Convert.ToInt32(enumerable[i]);
                            break;
                        case 12:
                            item.Fire = Convert.ToInt32(enumerable[i]);
                            break;
                        case 13:
                            item.Freeze = Convert.ToInt32(enumerable[i]);
                            break;
                        case 14:
                            item.Thunder = Convert.ToInt32(enumerable[i]);
                            break;
                        case 15:
                            item.Hypno = Convert.ToInt32(enumerable[i]);
                            break;
                        case 16:
                            item.Paralysis = Convert.ToInt32(enumerable[i]);
                            break;
                        case 17:
                            item.Flash = Convert.ToInt32(enumerable[i]);
                            break;
                        case 18:
                            item.Article = enumerable[i];
                            break;
                        case 19:
                            item.Sellable = Convert.ToInt32(enumerable[i]);
                            break;
                        case 20:
                            item.Price = Convert.ToInt32(enumerable[i]);
                            break;
                        case 21:
                            item.Iq = Convert.ToInt32(enumerable[i]);
                            break;
                        case 22:
                            item.Hp = Convert.ToInt32(enumerable[i]);
                            break;
                        case 23:
                            item.Pp = Convert.ToInt32(enumerable[i]);
                            break;
                        case 24:
                            item.Status = Convert.ToInt32(enumerable[i]);
                            break;
                    }

                    if (currItemLine == linesPerItem) {
                        gameItems.Add(item);
                        item = new GameItem();
                        currItemLine = 1;
                    } else {
                        currItemLine++;
                    }
                }

                foreach (var i in gameItems) {
                    itemGrid.Rows.Add(i.Id, i.Name, i.Desc, i.Effect, i.Equippable, i.EquipWho, i.Off, i.Def, i.Guts,
                        i.Speed, i.Target, i.Fire, i.Freeze, i.Thunder, i.Hypno, i.Paralysis, i.Flash, i.Article,
                        i.Sellable, i.Price, i.Iq, i.Hp, i.Pp, i.Status);
                }
                save_btn.Enabled = true;
            } catch (Exception) {
                save_btn.Enabled = false;
                MessageBox.Show(@"I can't read that script.
The formatting may be incorrect. Fix it and try again.", @"Whoopsie!", MessageBoxButtons.OK, MessageBoxIcon.Asterisk, MessageBoxDefaultButton.Button1);
            }

            //throw new Exception("");
        }

        private void item_id_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_description_TextChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_off_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_def_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_guts_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_speed_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_iq_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_sellable_CheckedChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_price_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_flash_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_paralysis_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_hypnosis_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_thunder_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_freeze_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_hp_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_pp_ValueChanged(object sender, EventArgs e)
        {
            update();
        }

        private void item_article_SelectedIndexChanged(object sender, EventArgs e)
        {
            update();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            update();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e) {
            update();
        }

        private void item_equippable_SelectedIndexChanged(object sender, EventArgs e) {
            update();
        }

        private void item_equip_target_SelectedIndexChanged(object sender, EventArgs e) {
            update();
        }

        private void item_target_SelectedIndexChanged(object sender, EventArgs e) {
            update();
        }

        private void item_effect_SelectedIndexChanged(object sender, EventArgs e) {
            update();
        }

        private void itemGrid_CellDoubleClick(object sender, DataGridViewCellEventArgs e) {
            MessageBox.Show(@"The item data has been copied to the clipboard.", @"", MessageBoxButtons.OK, MessageBoxIcon.Asterisk, MessageBoxDefaultButton.Button1);
        }
    }
}
