/*
 * Copy me if you can.
 * by 20h
 *
 * For now this is a slightly modified version of the original from
 * Matt Johnston <matt@ucc.asn.au>. See LICENSE.orig for his messages.
 */
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xlocale.h>
#include <locale.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <libgen.h>
#include <wchar.h>

#include "config.h"

unsigned long getcolor(const char *colstr);
XIMStyle choosebetterstyle(XIMStyle style1, XIMStyle style2);
void initim(void);
void createwindow(void);
void setupgc(void);
void eventloop(void);
void grabhack(void);
void redraw(void);
void keypress(XKeyEvent *keyevent);
void execcmd(void);
void die(char *errstr, ...);

Display *dpy;
GC gc;
GC rectgc;
XIM im;
XIC ic;
Window win;
XFontStruct *font_info;
XFontSet fontset;
int screen, issecret = 0, tostdout = 0;
unsigned long fgcol, bgcol;
static char *name = "thinglaunch";

#define MAXCMD 255
#define WINWIDTH 640
#define WINHEIGHT 25

/* the actual commandline */
wchar_t command[MAXCMD+1];
wchar_t secret[MAXCMD+1];
char cbuf[MAXCMD*4+1];

void
usage(char *argv0)
{
	fprintf(stderr, "usage: %s [-hos] [-p prompt]\n", argv0);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int i;

	if (strstr(argv[0], "thingaskpass")) {
		issecret = 1;
		tostdout = 1;
		prompt = "secret> ";
	}
	if (strstr(argv[0], "thingsudoaskpass")) {
		issecret = 1;
		tostdout = 1;
		if (argc > 1)
			prompt = argv[1];
		else
			prompt = "secret sudo> ";
		argc = 0;
	}

	if (argc > 1) {
		for (i = 1; argv[i]; i++) {
			if (argv[i][0] == '-') {
				switch (argv[i][1]) {
				case 'o':
					tostdout = 1;
					break;
				case 's':
					issecret = 1;
					break;
				case 'p':
					if (!argv[i+1])
						usage(argv[0]);
					prompt = argv[i+1];
					i++;
					break;
				default:
				case 'h':
					usage(argv[0]);
					break;
				}
			}
		}
	}

	bzero(command, sizeof(command));
	bzero(secret, sizeof(secret));

	createwindow();
	setupgc();
	grabhack();
	eventloop();

	return 0;
}

unsigned long
getcolor(const char *colstr)
{
	Colormap cmap = DefaultColormap(dpy, screen);
	XColor color;

	if (!XAllocNamedColor(dpy, cmap, colstr, &color, &color))
		die("error, canno allocate color '%s'\n", colstr);
	return color.pixel;
}

/*
 * Stolen from:
 * http://menehune.opt.wfu.edu/Kokua/Irix_6.5.21_doc_cd/usr/share/\
 * Insight/library/SGI_bookshelves/SGI_Developer/books/XLib_PG/sgi_\
 * html/ch11.html#S2-1002-11-11
 */
XIMStyle
choosebetterstyle(XIMStyle style1, XIMStyle style2)
{
	XIMStyle s,t;
	XIMStyle preedit = XIMPreeditArea | XIMPreeditCallbacks |
		XIMPreeditPosition | XIMPreeditNothing | XIMPreeditNone;
	XIMStyle status = XIMStatusArea | XIMStatusCallbacks |
		XIMStatusNothing | XIMStatusNone;
	if (style1 == 0) return style2;
	if (style2 == 0) return style1;
	if ((style1 & (preedit | status)) == (style2 & (preedit | status)))
		return style1;
	s = style1 & preedit;
	t = style2 & preedit;
	if (s != t) {
		if (s | t | XIMPreeditCallbacks)
			return (s == XIMPreeditCallbacks)?style1:style2;
		else if (s | t | XIMPreeditPosition)
			return (s == XIMPreeditPosition)?style1:style2;
		else if (s | t | XIMPreeditArea)
			return (s == XIMPreeditArea)?style1:style2;
		else if (s | t | XIMPreeditNothing)
			return (s == XIMPreeditNothing)?style1:style2;
	}
	else { /* if preedit flags are the same, compare status flags */
		s = style1 & status;
		t = style2 & status;
		if (s | t | XIMStatusCallbacks)
			return (s == XIMStatusCallbacks)?style1:style2;
		else if (s | t | XIMStatusArea)
			return (s == XIMStatusArea)?style1:style2;
		else if (s | t | XIMStatusNothing)
			return (s == XIMStatusNothing)?style1:style2;
	}
}

void
initim(void)
{
	XIMStyles *im_supported_styles;
	XIMStyle app_supported_styles;
	XIMStyle style;
	XIMStyle best_style;
	XVaNestedList list;
	char **missing_charsets;
	int num_missing_charsets = 0;
	char *default_string;
	int i;

	fontset = XCreateFontSet(dpy, font, &missing_charsets,
			&num_missing_charsets, &default_string);
	if (num_missing_charsets > 0)
		XFreeStringList(missing_charsets);

	if (!(im = XOpenIM(dpy, NULL, NULL, NULL)))
		die("Couldn't open input method.\n");

	XGetIMValues(im, XNQueryInputStyle, &im_supported_styles, NULL);
	app_supported_styles = XIMPreeditNone | XIMPreeditNothing \
	       | XIMPreeditArea;
	app_supported_styles |= XIMStatusNone | XIMStatusNothing \
				| XIMStatusArea;

	for(i = 0, best_style = 0; i < im_supported_styles->count_styles;
			i++) {
		style = im_supported_styles->supported_styles[i];
		if ((style & app_supported_styles) == style)
			best_style = choosebetterstyle(style, best_style);
	}
	if (best_style == 0)
		die("no common shared interaction style found.\n");
	XFree(im_supported_styles);

	list = XVaCreateNestedList(0, XNFontSet, fontset, NULL);
	ic = XCreateIC(im, XNInputStyle, best_style, XNClientWindow, win,
			XNPreeditAttributes, list, XNStatusAttributes,
			list, NULL);
	XFree(list);
	if (ic == NULL)
		die("Could not create input context.\n");
}

void
createwindow(void)
{
	char *display_name;
	int display_width, display_height;
	int top, left;
	XSizeHints *win_size_hints;
	XSetWindowAttributes attrib;
	XClassHint *ch;
	XTextProperty str;

	if (!setlocale(LC_CTYPE, "") || !XSupportsLocale())
		fprintf(stderr, "warning: no locale support.\n");

	display_name = getenv("DISPLAY");
	if (display_name == NULL)
		die("DISPLAY not set");

	dpy = XOpenDisplay(display_name);
	if (dpy == NULL)
		die("Couldn't connect to DISPLAY");

	if (!XSetLocaleModifiers(""))
		fprintf(stderr, "warning: could not set local modifiers.\n");

	initim();

	screen = DefaultScreen(dpy);
	display_width = DisplayWidth(dpy, screen);
	display_height = DisplayHeight(dpy, screen);

	top = (display_height/2 - WINHEIGHT/2);
	left = (display_width/2 - WINWIDTH/2);

	bgcol = getcolor(normbgcolor);
	fgcol = getcolor(normfgcolor);

	/*win = XCreateSimpleWindow(dpy, RootWindow(dpy, screen),
			left, top, WINWIDTH, WINHEIGHT, borderwidth,
			bgcol, bgcol);*/

	attrib.override_redirect= True;
	win = XCreateWindow(dpy, RootWindow(dpy, screen),
			left, top, WINWIDTH, WINHEIGHT,
			0, CopyFromParent,InputOutput,CopyFromParent,
			CWOverrideRedirect,&attrib);

	/* set up the window hints etc */
	win_size_hints = XAllocSizeHints();
	if (!win_size_hints)
		die("out of memory allocating hints");

	win_size_hints->flags = PMaxSize | PMinSize;
	win_size_hints->min_width = win_size_hints->max_width = WINWIDTH;

	win_size_hints->min_height = win_size_hints->max_height = WINHEIGHT;

	XStringListToTextProperty(&name, 1, &str);
	ch = XAllocClassHint();
	ch->res_class = name;
	ch->res_name = name;

	XSetWMProperties(dpy, win, &str, &str, NULL, 0, win_size_hints,
			NULL, ch);

	XFree(win_size_hints);
	XFree(ch);
	XFree(str.value);

	XMapWindow(dpy, win);
}

void
setupgc(void)
{
	XGCValues values;
	int valuemask = 0;
	int line_width = 1;
	int line_style = LineSolid;
	int cap_style = CapButt;
	int join_style = JoinBevel;

	gc = XCreateGC(dpy, win, valuemask, &values);
	rectgc = XCreateGC(dpy, win, valuemask, &values);
	XSetForeground(dpy, gc, fgcol);
	XSetBackground(dpy, gc, bgcol);

	XSetForeground(dpy, rectgc, bgcol);
	XSetBackground(dpy, rectgc, bgcol);

	XSetLineAttributes(dpy, gc, line_width, line_style,
			cap_style, join_style);

	/* setup the font */
	font_info = XLoadQueryFont(dpy, font);
	if (!font_info)
		die("couldn't load font");

	XSetFont(dpy, gc, font_info->fid);
}

void
eventloop(void)
{
	XEvent e;

	redraw();

	XSelectInput(dpy, win, ExposureMask | KeyPressMask);

	for (;;) {
		XNextEvent(dpy, &e);
		switch(e.type) {
		case Expose:
			redraw();
			break;
		case KeyPress:
			keypress(&e.xkey);
			break;
		default:
			break;
		}

	}
}

/* this loop is required since pwm grabs the keyboard during the event loop */
void
grabhack(void)
{
	int maxwait = 3000000; /* 3 seconds */
	int interval = 5000; /* 5 millisec */
	int i, x;

	redraw();

	/* if it takes longer than maxwait, just die */
	for (i = 0; i < (maxwait / interval); i++) {
		usleep(interval);
		x = XGrabKeyboard(dpy, win, False, GrabModeAsync,
				GrabModeAsync, CurrentTime);
		if (x == 0)
			return;
	}

	die("Couldn't grab keyboard");
}

void
redraw(void)
{
	int font_height, textwidth, promptwidth, dir, ascent, descent;
	XCharStruct cs;
	XRectangle ink, logical;

	font_height = font_info->ascent + font_info->descent;
	XTextExtents(font_info, prompt, strlen(prompt), &dir, &ascent,
			&descent, &cs);
	promptwidth = cs.width;
	XwcTextExtents(fontset, command, wcslen(command), &ink, &logical);
	textwidth = logical.width;
	textwidth += promptwidth;

	XFillRectangle(dpy, win, rectgc, 0, 0, WINWIDTH, WINHEIGHT);
	XDrawRectangle(dpy, win, gc, 0, 0, WINWIDTH-1, WINHEIGHT-1);
	XDrawString(dpy, win, gc, 2, font_height+2, prompt,
			strlen(prompt));
	XwcDrawString(dpy, win, fontset, gc, 4 + promptwidth,
			font_height+2, command, wcslen(command));
	XDrawLine(dpy, win, gc, 4 + textwidth, font_height + 2,
			4 + textwidth + 10, font_height+2);

	XFlush(dpy);
}

void
keypress(XKeyEvent *keyevent)
{
	KeySym key_symbol;
	int len;
	wchar_t buffer[3];

	len = XwcLookupString(ic, keyevent, buffer, 3, &key_symbol, NULL);
	buffer[len] = L'\0';

	switch(key_symbol) {
	case XK_Escape:
		exit(0);
		break;
	case XK_BackSpace:
		len = wcslen(command);
		if (len > 0) {
			command[len-1] = L'\0';
			if (issecret)
				secret[len-1] = L'\0';
		}
		break;
	case XK_Return:
	case XK_KP_Enter:
		execcmd();
		break;
	default:
		if (key_symbol > 255)
			break;

		len = wcslen(command);
		if (len < MAXCMD) {
			if (issecret) {
				secret[len] = buffer[0];
				secret[len+1] = L'\0';
				command[len] = L'*';
				command[len+1] = L'\0';
			} else {
				command[len] = buffer[0];
				command[len+1] = L'\0';
			}
		}
		break;
	}
	redraw();
}

void
execcmd(void)
{
	char *shell;

	XDestroyWindow(dpy, win);

	bzero(cbuf, sizeof(cbuf));
	if (issecret)
		wcstombs(cbuf, secret, sizeof(cbuf)-1);
	else
		wcstombs(cbuf, command, sizeof(cbuf)-1);

	if (tostdout) {
		printf("%s\n", cbuf);
		exit(0);
	}

	if (fork())
		exit(0);

	shell = getenv("SHELL");
	if (!shell)
		shell = "/bin/sh";

	execlp(shell, basename(shell), "-c", cbuf, (char *)NULL);
	die("aiee, after exec");
}


void
die(char *errstr, ...)
{
	va_list ap;

	va_start(ap, errstr);
	vfprintf(stderr, errstr, ap);
	va_end(ap);

	exit(1);
}

