# Thinglaunch - a simple entry box for X11 

The first intention, as done by the original creator Matt Johnston
<matt@ucc.asn.au>, was to launch simple commandlines.

In 2011 the single file project was extended by features like Unicode
support, a prompt and an ssh-askpass compatibility layer.

## Installation

	% tar -xzvf thinglaunch-*.tar.gz
	% cd thinglaunch
	% make
	% sudo PREFIX=/usr make install

This will create the executable »thinglaunch« and »thingaskpass« in
»/usr/bin«. Thinglaunch will ask for a command and execute it and
thingaskpass can be used as a SSH_ASKPASS parameter value, which will
be used by ssh-agent to gather the password for private keys.

## Usage

	# Get some input string and print it to stdout. There will
	# be the prompt prepended "to stdout> ".
	% thinglaunch -o -p "to stdout> "

	# Ask for a command, which will be executed. During entering
	# the command, the entered string will be replaced by asterisks. 
	% thinglaunch -s -p "secret cmd> "

	# This symlink predefines -s, -o and -p "secret> ".
	% ln -s thinglaunch thingaskpass
	% ./thingaskpass

Have fun!

