#ifndef __GRAMSCII_H__
#define __GRAMSCII_H__

#define _POSIX_C_SOURCE 2 

#include <stdio.h>
#include <termios.h>
#include <unistd.h>



/** constants **/

/* modes */
#define MOVE   0x00
#define BOX    0x01
#define ARROW  0x02
#define TEXT   0x04
#define DEL    0x08
#define VIS    0x10
/**/

/* directions */
#define DIR_N  0x00
#define DIR_R  0x01
#define DIR_U  0x02
#define DIR_D  0x04
#define DIR_L  0x08

#define DIR_HOR (DIR_R | DIR_L)
#define DIR_VER (DIR_D | DIR_U)
/**/

#define NOFIX 0x0
#define FIX   0x1

/* markers */
#define BG        ' '
#define PTR       '+'
#define UND       '_'
#define ARR_L     '<'
#define ARR_R     '>'
#define ARR_U     '^'
#define ARR_D     'v'
/**/

/* global positions */
#define HOME   0x01
#define END    0x02
#define MIDDLE 0x04
/**/

/* video modes */
#define VIDEO_NRM 0
#define VIDEO_REV 7 
/**/

/* undo buffer elem types */
#define PRV_STATE 0x01
#define NEW_STATE 0x02
/**/

/* file types */
#define FFILE 0x01
#define FPIPE 0x02

/** types **/

typedef struct{
	int sz;/* allocated size */
	int n;/* line number */
	int lst;/* last visible char (before the first \0) */
	char *s;
} line_t;

typedef struct{
	int sz;/* allocated size */
	int num;/* number of lines stored */
	line_t *l;
} lineset_t;


/** MACROS **/

#define MIN(x,y)  (x) < (y) ? (x) : (y)
#define MAX(x,y)  (x) > (y) ? (x) : (y)

#define progr_x(d) ((d) == DIR_L ? -1 : (d) == DIR_R ? 1 : 0)
#define progr_y(d) ((d) == DIR_U ? -1 : (d) == DIR_D ? 1 : 0)

/** global variables **/ 

lineset_t screen; /* what is visualised */
lineset_t cutbuf; /* cut/paste buffer */
lineset_t *undo;  /* undo list */

int undo_sz;/* allocated size of undo list*/
int undo_cur;/* undo position */
int undo_lst;/* last valid undo position */

int WIDTH, HEIGHT;

int mode;/* mode */
int dir;/* line direction */
int x;
int y;
int step;/* current step */
int mult;/* current multiplier */
int force_new;
char corner;

/* number of available markers for each type */
int hlines_sz;
int vlines_sz;
int corners_sz;
int stmarks_sz;
int endmarks_sz;
/**/

/* line and arrow markers */
int cur_hl, cur_vl, cur_corn, cur_start, cur_end;
char line_h;
char line_v;
char mark_st;
char mark_end;
/**/

char modified; /* set to 1 if screen modified since last save */ 
char fname[256];


char silent; /* set to 1 in script-mode */
char autoend; /* set to 1 in auto-arrow mode */

/* Used by draw_arrow to identify the bounding box */
int a_miny;
int a_maxy;
/**/

struct termios t1, t2, t3;

/** screen-related functions **/
void reset_styles();
void redraw();
int move_around(char c, FILE *fc, char global);
void check_bound(int *x, int *y);
void status_bar();
void show_cursor();
void set_cur(char c);
void update_current();
void set_xy(int _x, int _y, char c);
void draw_xy(int x, int y, char c);
char get_mark(char dir);
void set_video(int v);
char get_key(FILE *fc, char *msg);
void get_string(FILE *fc, char *msg, char *s, int sz);
void erase_box(int x1, int y1, char c);
int is_yes(char c);
void init_screen();
void erase_line(int i);
void erase_screen();
void go_to(int where);
void crop_to_nonblank();
void crop_to_rect();
void erase_blank_lines(int y1, int y2);
int _isblank(int c);
/**/

/** drawing-related functions **/
int change_style(char c);
void get_text(FILE *fc);
void get_box(FILE *fc);
void get_arrow(FILE *fc);
void erase(FILE *fc);
void visual_box(FILE *fc);
void paste();
void undo_change();
void redo_change();
/**/

/** file-related functions **/
void write_file(FILE *fc);
void check_modified(FILE *fc);
void load_file(FILE *fc);
void new_file(FILE *fc);
void read_file_at(FILE *fc, int xl, int yl);
/**/

/** line-related functions **/
void dump_lines(lineset_t ls, FILE *f);
void alloc_line(line_t *l);
void ensure_line_length(line_t *l, int len);
void ensure_num_lines(lineset_t *ls, int n);
void yank_region(int x1, int y1, int x2, int y2);
void paste_region(int x1, int y1);
void copy_lines_to_ring(int y1, int y2, int which);
void invalidate_undo();
/**/

void cleanup(int);

#endif
