#define _POSIX_C_SOURCE 2 

#include <stdio.h>
#include <string.h>
#include "gramscii.h"


/*** File management ***/

void write_file(FILE *fc){
	FILE *fout;
	int i, ne;

	if (!fname[0] || force_new){
		get_string(fc, "Write to: ", fname, 255);
		if ((fout=fopen(fname, "r"))!=NULL){
			if (!is_yes(get_key(fc,"File exists. Overwrite [y/n]?")) ){
				fclose(fout);
				return;
			}
			fclose(fout);
		}
	}
	if((fout=fopen(fname, "w"))==NULL){
		get_key(fc, "Error opening file.");
		return;
	}
	ne = 0;
	for (i=0; i<HEIGHT; i++){
		if (strlen(screen.l[i].s)){/* remove trailing blank lines */
			/* put the empty lines preceeding the current non-empty one */
			while (ne--)
				fprintf(fout, "\n");
			fprintf(fout, "%s\n", screen.l[i].s);
			ne = 0;
		}
		else ne++;
	}
	fclose(fout);
	modified = 0;
	get_key(fc, "File saved.");
	redraw();
}

void check_modified(FILE *fc){

	if (modified){
		if (!is_yes(get_key(fc, "Unsaved changes. Write to file [y/n]?")) ){
			return;
		}
		write_file(fc);
	}
}

void load_file(FILE *fc){

	char newfname[256];
	FILE *fin;
	int i;

	get_string(fc, "Load file: ", newfname, 255);
	if ((fin=fopen(newfname, "r")) != NULL){
		i = 0;
		while((fgets(screen.l[i].s, WIDTH+1, fin)) != NULL && i<HEIGHT){
			screen.l[i].lst = strlen(screen.l[i].s) - 2;
			screen.l[i].n = i;
			screen.l[i].s[strlen(screen.l[i].s)-1]='\0';
			i++;
		}
		for(;i<HEIGHT; i++){
			erase_line(i);
		}
		fclose(fin);
	}
	strcpy(fname, newfname);
	modified=0;
	redraw();
}

void new_file(FILE *fc){
	check_modified(fc);
	erase_screen();
	go_to(HOME);
	redraw();
	fname[0] = '\0';
	modified=0;
}

void read_file_at(FILE *fc, int xl, int yl){

	char nfname[512], tmp[512], *fptr, *tptr;
	FILE *fin;
	int i, j;
	char ftype;

	get_string(fc, "Read file: ", nfname, 511);
	fptr = nfname;
	while(*fptr && _isblank(*fptr))
		 fptr ++;
	if (*fptr == '!'){
		fin = popen(++fptr, "r");
		ftype = FPIPE;
	}
	else {
		fin = fopen(fptr, "r");
		ftype = FFILE;
	}
	if (fin != NULL){
		copy_lines_to_ring(0, HEIGHT-1, PRV_STATE);
		i = yl;
		while((fgets(tmp, WIDTH+1, fin)) != NULL && i<HEIGHT){
			j = xl;
			tptr = tmp;
			if (strlen(tmp))
				tmp[strlen(tmp) - 1] = '\0';
			ensure_line_length(& (screen.l[i]), xl + strlen(tmp) + 1);
			while (*tptr && j < WIDTH){
				set_xy(j, i, *tptr);
				j++;
				tptr ++;
			}
			i++;
		}
		if (ftype == FFILE)
			fclose(fin);
		else
			pclose(fin);
		modified = 1;
		redraw();
		copy_lines_to_ring(yl, i-1, NEW_STATE);
	}
}
