#include <stdio.h>
#include <string.h>
#include "gramscii.h"


/*** File management ***/

void write_file(FILE *fc){
	FILE *fout;
	int i;

	if (!fname[0] || force_new){
		get_string(fc, "Write to: ", fname, 255);
		if ((fout=fopen(fname, "r"))!=NULL){
			if (!is_yes(get_key(fc,"File exists. Overwrite [y/n]?")) ){
				fclose(fout);
				return;
			}
			fclose(fout);
		}
	}
	if((fout=fopen(fname, "w"))==NULL){
		get_key(fc, "Error opening file.");
		return;
	}
	for (i=0; i<HEIGHT; i++){
		fprintf(fout, "%s\n", screen.l[i].s);
	}
	fclose(fout);
	modified = 0;
	get_key(fc, "File saved.");
}

void check_modified(FILE *fc){

	if (modified){
		if (!is_yes(get_key(fc, "Unsaved changes. Write to file [y/n]?")) ){
			return;
		}
		write_file(fc);
	}
}

void load_file(FILE *fc){

	char newfname[256];
	FILE *fin;
	int i;

	get_string(fc, "Load file: ", newfname, 255);
	if ((fin=fopen(newfname, "r")) != NULL){
		i = 0;
		while((fgets(screen.l[i].s, WIDTH+2, fin)) != NULL && i<HEIGHT)
			screen.l[i++].s[WIDTH-1]='\0';
		for(;i<HEIGHT; i++){
			erase_line(i);
		}
		fclose(fin);
	}
	strcpy(fname, newfname);
	modified=0;
	redraw();
}

void new_file(FILE *fc){
	check_modified(fc);
	erase_screen();
	go_to(HOME);
	redraw();
	fname[0] = '\0';
	modified=0;
}

