gramscii -- interactive tool for ASCII box-and-arrows charts
============================================================

`gramscii` (pronounced "grrr'a(m)sky", more or less like "ASCII" but
with a leading "grrr") is a simple CLI tool to create and edit
box-and-arrows charts using ASCII characters. 

`gramscii` is interactive and its commands are quite intuitive to
anybody who does not need a mouse to be productive. You can move around
the screen with the usual `hjkl` keys, but you will travel at
ligthning speed by placing one of your other fingers on `SHIFT`. You
start drawing a box with `b`, and you place an arrow with `a`.
For more information, just read the manpage. 

`gramscii` aims at remaining small, avoiding bloat, and being
portable. It is written in ASCII C90, it requires only an ANSI
VT100-compatible terminal (real or virtual), and it does not use any
external library (nope, not even ncurses!). Hence, you should be able to
compile and run `gramscii` on any operating system with a C90 libc
and a VT100 terminal emulator. 

I have tested it on Linux and *BSD, compiled with `gcc`,
`clang`, and `tcc`, and linked it against `glibc`,
`musl`, and whatever libc was available on FreeBSD, OpenBSD, and
NetBSD. It just worked.

INSTALL
=======

Edit `config.h` and/or `config.mk` to suit your preferences.
Then just:
```
make
```

to build `gramsci` and:
```
./gramscii
```
to execute it. `man` is your friend.


WHY?
====

As most of the software out there, `gramscii` comes out of
frustration and pain. 

I have been producing box-and-arrow diagrams in ASCII for quite a while.
I know that there exist ad-hoc plugins for `vim(1)` and
`emacs(1)`, but I was not happy with any of them, to say the least.
There are also a few point-and-click GUI tools to do the same, but most
of them depend on a variety of libraries/modules. And again, why would
you need a fancy GUI to create ASCII charts? 

There has been a recent proliferation of browser-based point-and-click
tools to draw ASCII charts. Like, are you serious? Why on Earth should
people accept to load hundred thousands LOCs of obscure javascript code
on a hyper-bloated web browser and use a fancy point-and-click interface
to produce......guess what......ASCII charts that are best-viewed viewed
on a VT100 terminal?

We must say no to madness. We must repudiate bloat. We must reject
useless featurism. Software must be reasonable, simple, small, and
functional.

But wait... 
============

You might have noticed that the name `gramscii` is reminiscent of
Antonio Gramsci, the phylosopher and politician who was among the
founders of the Italian Communist Party in 1921. Now, Gramscii (the
philosopher) strongly believed that every single human is an
intellectual, a philosopher, and an artist, and maintained that societal
changes are only possible when a class exerts intellectual and moral
leadership over its contemporaries. So just get rid of all your shiny
iPointless things and come back to reality. 
