#!/bin/sh
#
# See LICENSE for copyright information.
#
# Gemini Proxy CGI script:
#	https://gemini.circumlunar.space/docs/specification.gmi
#

search="$1"
arguments="$2"
host="$3"
port="$4"
traversal="$5"
selector="$6"

proxybase="/gemini/?"

case "${arguments}" in
gemini://*)
	;;
*)
	exit 1
	;;
esac

geminihost="$(printf "%s\n" "${arguments}" | cut -d'/' -f 3)"
[ -z "${geminihost}" ] && exit 1
geminiport="$(printf "%s\n" "${geminihost}" | cut -d':' -f 2)"
[ "${geminiport}" = "${geminihost}" ] && geminiport="1965"

function untabtext() {
	printf "%s\n" "$1" | sed 's,\t,       ,g'
}

line0=""
printf "%s\r\n" "${arguments}" \
	| socat - "openssl:${geminihost}:${geminiport},verify=0" \
| { 
	read -r line
	line0="${line}"
	line0meta="$(printf "%s\n" "${line0}" | cut -d' ' -f 2-)"
	case "${line0}" in
	1*)
		printf "3search query input required\t\t\t\r\n"
		exit 1
		;;
	2*)
		# Only fallthrough.
		;;
	3*)
		printf "3redirect to: %s\t\t\t\r\n" "${line0meta}"
		exit 1
		;;
	4*)
		printf "3temporary failure\t\t\t\r\n"
		exit 1
		;;
	5*)
		printf "3permanent failure\t\t\t\r\n"
		exit 1
		;;
	6*)
		printf "3client certificate required\t\t\t\r\n"
		exit 1
		;;
	*)
		printf "3unknown error\t\t\t\r\n"
		exit 1
		;;
	esac

	case "${line0meta}" in
	text/gemini*)
		preformat=0
		while read -r line;
		do
			case "${line}" in
			"\`\`\`"*)
				if [ $preformat -eq 1 ];
				then
					preformat=0
				else
					preformat=1
				fi
				;;
			"=>"*)
				if [ $preformat -eq 1 ];
				then
					printf "i%s\tErr\t%s\t%s\r\n" "$(untabtext "${line}")" \
						"${host}" "${port}"
					continue
				fi
				geminiuri="$(printf "%s\n" "${line}" \
					| sed -e 's,^=>[ \t]*\([^ \t]*\).*$,\1,g')"
				geminidesc="$(printf "%s\n" "${line}" \
					| sed -e 's,^=>[ \t]*[^ \t]*[ \t]*\(.*\)$,\1,g')"

				gophertype="9"
				gopherhost="${host}"
				gopherport="${port}"
				gopherselector=""
				if [ -z "${geminidesc}" ];
				then
					gopherdesc="${geminiuri}"
				else
					gopherdesc="${geminidesc}"
				fi
				case "${geminiuri}" in
				gopher*)
					gopherhost="$(printf "%s\n" "${geminiuri}" | cut -d'/' -f 3)"
					[ -z "${geminihost}" ] && exit 1
					gopherport="$(printf "%s\n" "${gopherhost}" | cut -d':' -f 2)"
					[ "${gopherport}" = "${gopherhost}" ] && gopherport="70"
					gopherrequest="$(printf "%s\n" "${geminiuri}" | cut -d'/' -f 4-)"
					# Gemini does not properly support
					# gopher query requests.
					# TODO: Fix gemini protocol.
					gophertype="$(printf "%s\n" "${gopherrequest}" | cut -c 1)"
					gopherselector="$(printf "%s\n" "${gopherrequest}" | cut -c 2-)"
					;;
				gemini*)
					gophertype="1"
					gopherselector="${proxybase}${geminiuri}"
					;;
				*)
					gophertype="h"
					gopherselector="URL:${geminiuri}"
					;;
				esac
				printf "%s%s\t%s\t%s\t%s\r\n" \
					"$gophertype" \
					"$(untabtext "$gopherdesc")" \
					"$gopherselector" \
					"$gopherhost" \
					"$gopherport"
				;;
			*)
				if [ $preformat -eq 1 ];
				then
					printf "i%s\tErr\t%s\t%s\r\n" "$(untabtext "${line}")" \
						"${host}" "${port}"
				else
					{
						printf "%s\n" "${line}" \
							| par-format -w 74
					} \
					| while read -r line;
					do
						printf "i%s\tErr\t%s\t%s\r\n" "$(untabtext "${line}")" \
							"$host" "$port"
					done
				fi
				;;
			esac
		done
		;;
	esac
	cat
}

