#!/bin/bash
#
# Copy me, if you can.
# by 20h
#

#set -x

lockbasepath="/tmp/dreadlock-ng"
if [ $# -gt 0 ];
then
	lockbasepath="$1"
fi

mkdir -p "${lockbasepath}"

declare -A locks=()

function unlock_on_disconnect() {
	for lockfd in ${locks[@]};
	do
		flock -u "${lockfd}" 2>/dev/null
	done
	for lockname in ${!locks[@]};
	do
		[ -e "${lockbasepath}/${lockname}" ] && rm -f "${lockbasepath}/${lockname}";
	done
}

trap unlock_on_disconnect EXIT
trap unlock_on_disconnect 1
trap unlock_on_disconnect 2
trap unlock_on_disconnect 3
trap unlock_on_disconnect 6
trap unlock_on_disconnect 9
trap unlock_on_disconnect 15

while read -r line;
do
	case "${line}" in
	"lock "*)
		lockname="$(printf "%s\n" "${line}" | tr -d $'\r' | cut -d' ' -f 2)"
		if [ -z "${lockname}" ];
		then
			printf "e no lock name specified\r\n"
			exit 1;
		fi
		if [[ "${lockname}" =~ [^a-zA-Z0-9] ]];
		then
			printf "e lock name must be alphanumeric\r\n"
			exit 1
		fi
		timeoutms="$(printf "%s\n" "${line}" | tr -d $'\r' | cut -d' ' -f 3)"
		if [ -z "${timeoutms}" ];
		then
			printf "e no timeout specified\r\n"
			exit 1;
		fi
		if [[ "${timeoutms}" =~ [^0-9] ]];
		then
			printf "e timeout must be numeric\r\n"
			exit 1
		fi
		timeouts="$(units -t "${timeoutms}ms" "s" 2>/dev/null)"
		case "${timeouts}" in
		0*)
			# flock(1) needs at least one second.
			timeouts=1
			;;
		esac

		lockpath="${lockbasepath}/${lockname}"
		touch "${lockpath}"
		exec {fd}<>"${lockpath}"
		flock -x -w "${timeouts}" "${fd}"
		if [ $? -gt 0 ];
		then
			printf "t timeout\r\n"
			exit 1
		fi
		locks[${lockname}]+="${fd}"
		printf "l locked\r\n"
		;;
	"unlock "*)
		lockname="$(printf "%s\n" "${line}" | tr -d $'\r' | cut -d' ' -f 2)"
		if [ -z "${lockname}" ];
		then
			printf "e no lock name specified\r\n"
			exit 1;
		fi
		if [[ "${lockname}" =~ [^a-zA-Z0-9] ]];
		then
			printf "e lock name must be alphanumeric\r\n"
			exit 1
		fi

		lockfd=${locks[${lockname}]}
		if [ -z "${lockfd}" ];
		then
			printf "e unknown lock\r\n"
			exit 1
		fi

		flock -u "${lockfd}"
		if [ $? -gt 1 ];
		then
			printf "e unlock error\r\n"
			exit 1
		fi
		printf "u unlocked\r\n"
		;;
	*)
		exit 1;
	esac	
done

exit 0

