/*
 * ISC License
 *
 * (c) 2019 Roberto E. Vargas Caballero <k0ga@shike2.com>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

static int
lunpack(unsigned char *src, char *fmt, va_list va)
{
	unsigned char *bp, *cp;
	unsigned short *sp;
	unsigned s;
	unsigned long *lp, l;
	unsigned long long *qp, q;
	int n;

	bp = src;
	while (*fmt) {
		switch (*fmt++) {
		case '\'':
			n = atoi(fmt);
			while (isdigit(*fmt))
				fmt++;
			cp = va_arg(va, unsigned char *);
			while (n--)
				*cp++ = *bp++;
			break;
		case 'c':
			cp = va_arg(va, unsigned char *);
			*cp = *bp++;
			break;
		case 's':
			sp = va_arg(va, unsigned short *);
			s =  (unsigned) *bp++;
			s |= (unsigned) *bp++ << 8;
			*sp = s;
			break;
		case 'l':
			lp = va_arg(va, unsigned long *);
			l = (unsigned long) *bp++;
			l |= (unsigned long) *bp++ << 8;
			l |= (unsigned long) *bp++ << 16;
			l |= (unsigned long) *bp++ << 24;
			*lp = l;
			break;
		case 'q':
			qp = va_arg(va, unsigned long long *);
			q = (unsigned long long) *bp++;
			q |= (unsigned long long) *bp++ << 8;
			q |= (unsigned long long) *bp++ << 16;
			q |= (unsigned long long) *bp++ << 24;
			q |= (unsigned long long) *bp++ << 32;
			q |= (unsigned long long) *bp++ << 40;
			q |= (unsigned long long) *bp++ << 48;
			q |= (unsigned long long) *bp++ << 56;
			*qp = q;
			break;
		default:
			va_end(va);
			return -1;
		}
	}

	return bp - src;
}

int
unpack(unsigned char *src, char *fmt, ...)
{
	int r;
        int (*fn)(unsigned char *dst, char *fmt, va_list va);
        va_list va;

        va_start(va, fmt);
        fn = lunpack;
        r = (*fn)(src, fmt, va);
        va_end(va);

        return r;
}
