#ifdef __linux__
#define _GNU_SOURCE
#include <fcntl.h>

int
punchhole(int fd, off_t offset, off_t len)
{
	int mode;

	mode = FALLOC_FL_PUNCH_HOLE | FALLOC_FL_KEEP_SIZE;
	return fallocate(fd, mode, offset, len);
}
#else
#include <sys/types.h>
#include <unistd.h>

int
punchhole(int fd, off_t offset, off_t len)
{
	return -1;
}
#endif
