#include "config.h"

#define MSGSIZE 256
#define MDSIZE 32

/* snashot file format version */
#define VER_MIN 1
#define VER_MAJ 0

struct cache;
struct chunker;

struct stats {
	uint64_t orig_size;
	uint64_t comp_size;
	uint64_t dedup_size;
	uint64_t min_blk_size;
	uint64_t max_blk_size;
	uint64_t nr_blks;
	uint64_t reserved[6];
};

struct snapshot_hdr {
	uint64_t flags;
	uint64_t nr_snapshots;
	uint64_t store_size;
	uint64_t reserved[4];
	struct stats st;
};

struct blk_desc {
	uint8_t md[MDSIZE];
	uint64_t offset;
	uint64_t size;
};

struct snapshot {
	uint64_t size;
	uint8_t msg[MSGSIZE];
	uint8_t md[MDSIZE];	/* hash of snapshot */
	uint64_t nr_blk_descs;
	struct blk_desc blk_desc[];
};

struct cache_entry {
	uint8_t md[MDSIZE];
	uint64_t offset;
	uint64_t size;
};

/* cache.c */
struct cache *alloc_cache(void);
void free_cache(struct cache *cache);
void add_cache_entry(struct cache *cache, struct cache_entry *ent);
int lookup_cache_entry(struct cache *cache, struct cache_entry *ent);
void walk_cache(struct cache *cache, int (*fn)(struct cache_entry *));

/* chunker.c */
struct chunker *alloc_chunker(size_t cap, int fd);
void free_chunker(struct chunker *chunker);
ssize_t fill_chunker(struct chunker *chunker);
uint8_t *get_chunk(struct chunker *chunker, size_t *chunk_size);
void drain_chunker(struct chunker *chunker);

/* hash.c */
uint32_t buzh_init(uint8_t *buf, size_t size);
uint32_t buzh_update(uint32_t fp, uint8_t in, uint8_t out, size_t size);

/* pack.c */
int pack(unsigned char *dst, char *fmt, ...);

/* unpack.c */
int unpack(unsigned char *src, char *fmt, ...);

/* utils.c */
void str2bin(char *s, uint8_t *d);
off_t xlseek(int fd, off_t offset, int whence);
ssize_t xread(int fd, void *buf, size_t nbytes);
ssize_t xwrite(int fd, const void *buf, size_t nbytes);
