#include "config.h"

struct chunker;

/* chunker.c */
struct chunker *alloc_chunker(size_t cap, int fd);
void free_chunker(struct chunker *chunker);
ssize_t fill_chunker(struct chunker *chunker);
uint8_t *get_chunk(struct chunker *chunker, size_t *chunk_size);
void drain_chunker(struct chunker *chunker);

/* hash.c */
uint32_t buzh_init(uint8_t *buf, size_t size);
uint32_t buzh_update(uint32_t fp, uint8_t in, uint8_t out, size_t size);

/* pack.c */
int pack(unsigned char *dst, char *fmt, ...);

/* unpack.c */
int unpack(unsigned char *src, char *fmt, ...);

/* utils.c */
void str2bin(char *s, uint8_t *d);
off_t xlseek(int fd, off_t offset, int whence);
ssize_t xread(int fd, void *buf, size_t nbytes);
ssize_t xwrite(int fd, const void *buf, size_t nbytes);
