#!/bin/sh
# generate table of hashtag numbers over time

if [ $# -lt 1 ];
then
	printf "usage: %s annnadir [memecount.log]\n" "$(basename "$0")" >&2
	exit 1
fi

annnadir="${1}"
memefile="modules/hashtags/hashtags.txt"
update_annna=yes
outputfile="${2:-memecount.log}"
revisionrange=""
datefmt="%Y-%m-%d"

if [ ! -e "${annnadir}/${memefile}" ]; then
	printf 'error: could not open %s\n' "${annnadir}/${memefile}"
	exit 1
fi

if [ -f "${outputfile}" ]; then
	lastrevision="$(tail -n 1 "${outputfile}" | cut -f 2)"
	revisionrange="${lastrevision}..HEAD"
	if [ "$(date +"${datefmt}")" = "$(tail -n 1 "${outputfile}" | cut -f 1)" ]; then
		exit
	fi
else
	firstrevision="$(cd "${annnadir}" && git rev-list --max-parents=0 HEAD)"
	revisionrange="${firstrevision}..HEAD"
fi

case "${outputfile}" in
/*)
	;;
*)
	outputfile="$(pwd)/${outputfile}"
	;;
esac

if [ "$update_annna" = "yes" ]; then
	(cd "${annnadir}" && git pull >/dev/null 2>&1)
fi

headcommit="$(git rev-parse HEAD)"
i=0
# derived from Hiltjo Posthuma's loc.sh
(cd "${annnadir}" && git log --pretty='format:%H %cd %at' --date="format:${datefmt}" \
	"${revisionrange}") | \
	sort -k 2 | uniq -f 1 | \
	while read -r commit date timestamp; do

	# hashtags originally stored in annna-start-services...
	n="$(cd "${annnadir}" && git show "$commit:annna-start-services" 2>/dev/null | \
		grep -E '^	#[a-z0-9]' | wc -l | awk '{print $1}')"

	# ...but are now stored in $memefile
	if [ "$n" -le 1 ]; then
		n="$(cd "${annnadir}" && git show "$commit:$memefile" 2>/dev/null | \
		     wc -l | awk '{print $1}')"
	fi

	if [ "$n" -gt 1 ]; then
		
		# only one row per day unless the most recent commit is newer
		if [ "$date" != "$lastprintdate" ] || [ "$commit" = "$headcommit" ]; then

			if [ "$i" -eq 1 ]; then
				if [ "$commit" != "$headcommit" ]; then
					dn_dt="$(awk \
						-v n0="$n0" -v t0="$t0" -v n="$n" -v t="$timestamp" \
						'BEGIN{print (n-n0)/(t-t0)*3600.0*24.0}')"
				fi
			else
				dn_dt=0
				i=1
			fi
			n0="$n"
			t0="$timestamp"
			lastprintdate="$date"

			printf '%s\t%s\t%s\t%s\t%s\n' \
				"$date" "$commit" "$n" "$timestamp" "$dn_dt" \
				>> "${outputfile}"

		fi
	fi
done

