#!/bin/sh
# generic git post-receive hook.
# change the config options below and call this script in your post-receive
# hook or symlink it.
#
# usage: $0 [name]
#
# if name is not set the basename of the current directory is used,
# this is the directory of the repo when called from the post-receive script.

name="$1"
if test "${name}" = ""; then
	name=$(basename $(pwd))
fi

# config
# paths must be absolute.
reposdir="/home/src/src"
dir="${reposdir}/${name}"
gopherdir="/home/www/gopher"
stagitdir="/"
destdir="${gopherdir}/${stagitdir}"
cachefile=".gphcache"
# /config

if ! test -d "${dir}"; then
	echo "${dir} does not exist" >&2
	exit 1
fi
cd "${dir}" || exit 1

# detect git push -f
force=0
while read -r old new ref; do
	test "${old}" = "0000000000000000000000000000000000000000" && continue

	hasrevs=$(git rev-list "${old}" "^${new}" | sed 1q)
	if test -n "${hasrevs}"; then
		force=1
		break
	fi
done

# strip .git suffix.
r=$(basename "${name}")
d=$(basename "${name}" ".git")
printf "[%s] stagit .gph pages... " "${d}"

mkdir -p "${destdir}/${d}"
cd "${destdir}/${d}" || exit 1

# remove commits and ${cachefile} on git push -f, this recreated later on.
if test "${force}" = "1"; then
	rm -f "${cachefile}"
	rm -rf "commit"
fi

# remove /'s at the end.
stagitdir=$(printf "%s" "${stagitdir}" | sed 's@[/]*$@@g')

# make index.
stagit-gopher-index -b "${stagitdir}" "${reposdir}/"*/ > "${destdir}/index.gph"

# make pages.
stagit-gopher -b "${stagitdir}/${d}" -c "${cachefile}" "${reposdir}/${r}"

ln -sf log.gph index.gph

echo "done"
