#ifndef TSV_H
#define TSV_H

#include <stdio.h>
#include <time.h>

/*
 * List of values and timestamps.  Both have their dedicated buffer
 * so that the timestamp buffer can be shared across tsv objects.
 */
struct tsv {
	time_t		*t;		/* array of timestamps */
	double		*v;		/* array of values */
	size_t		n;		/* number of values */
	char		label[64];	/* for the legend */
};

void	tsv_labels(FILE *, struct tsv **, size_t *);
void	tsv_values(FILE *, struct tsv *, size_t);
int	tsv_min_max(struct tsv *, int, time_t *, time_t *, double *, double *);

#endif
