#include <sys/types.h>

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define NERRBUF	128
static char errbuf[NERRBUF];

ssize_t
xread(int fd, void *buf, size_t nbytes)
{
	unsigned char *bp = buf;
	ssize_t total = 0;

	while (nbytes > 0) {
		ssize_t n;

		n = read(fd, &bp[total], nbytes);
		if (n < 0)
			return -1;
		else if (n == 0)
			return total;
		total += n;
		nbytes -= n;
	}
	return total;
}

ssize_t
xwrite(int fd, void *buf, size_t nbytes)
{
	unsigned char *bp = buf;
	ssize_t total = 0;

	while (nbytes > 0) {
		ssize_t n;

		n = write(fd, &bp[total], nbytes);
		if (n < 0)
			return -1;
		else if (n == 0)
			return total;
		total += n;
		nbytes -= n;
	}
	return total;
}

void
seterr(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsnprintf(errbuf, NERRBUF, fmt, ap);
	va_end(ap);
}

void
printerr(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	if (errbuf[0] == '\0')
		fprintf(stderr, ": unknown error\n");
	else
		fprintf(stderr, ": %s\n", errbuf);
	va_end(ap);
	exit(1);
}
