#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <unistd.h>

int
lockrepo(char *repo)
{
	char path[PATH_MAX];
	struct flock fl;
	int fd;

	if (snprintf(path, sizeof(path), "%s/lock", repo) >=
	    sizeof(path))
		return -1;

	fd = open(path, O_RDWR | O_CREAT, 0600);
	if (fd < 0)
		return -1;
	fl.l_type = F_WRLCK;
	fl.l_whence = SEEK_SET;
	fl.l_start = 0;
	fl.l_len = 0;
	if (fcntl(fd, F_SETLK, &fl) < 0) {
		close(fd);
		return -1;
	}
	return fd;
}

int
unlockrepo(int fd)
{
	struct flock fl;

	fl.l_type = F_UNLCK;
	fl.l_whence = SEEK_SET;
	fl.l_start = 0;
	fl.l_len = 0;
	if (fcntl(fd, F_SETLK, &fl) < 0)
		return -1;
	if (close(fd) < 0)
		return -1;
	return 0;
}
