#include <assert.h>
#include <unistd.h>

#include <sodium.h>

#include "config.h"
#include "misc.h"

int
keygen(unsigned char *key, size_t n)
{
	assert(KEYSIZE == crypto_aead_xchacha20poly1305_ietf_KEYBYTES);
	if (n != KEYSIZE) {
		seterr("invalid key size");
		return -1;
	}
	if (sodium_init() < 0) {
		seterr("sodium_init: failed");
		return -1;
	}
	crypto_aead_xchacha20poly1305_ietf_keygen(key);
	return 0;
}

int
writekey(int fd, unsigned char *key, size_t n)
{
	assert(KEYSIZE == crypto_aead_xchacha20poly1305_ietf_KEYBYTES);
	if (n != KEYSIZE) {
		seterr("invalid key size");
		return -1;
	}
	if (xwrite(fd, key, n) != n) {
		seterr("failed to write key");
		return -1;
	}
	return 0;
}

int
readkey(int fd, unsigned char *key, size_t n)
{
	assert(KEYSIZE == crypto_aead_xchacha20poly1305_ietf_KEYBYTES);
	if (n != KEYSIZE) {
		seterr("invalid key size");
		return -1;
	}
	if (xread(fd, key, n) != n) {
		seterr("failed to read key");
		return -1;
	}
	return 0;
}
