enum {
	B_READ  = 1 << 0,
	B_RDWR	= 1 << 1,
};
	
struct bctx {
	void *gctx;	/* generic layer context (unused) */
	void *cctx;	/* compression layer context */
	void *ectx;	/* encryption layer context */
	void *sctx;	/* storage layer context */
};

/*
 * Block operations structure.
 * This is implemented by each of the block layers.
 */
struct bops {
	int (*creat)(struct bctx *, char *, int);
	int (*open)(struct bctx *, char *, int, int);
	int (*put)(struct bctx *, void *, size_t, unsigned char *);
	int (*get)(struct bctx *, unsigned char *, void *, size_t *);
	int (*rm)(struct bctx *, unsigned char *);
	int (*gc)(struct bctx *);
	int (*sync)(struct bctx *);
	int (*close)(struct bctx *);
};

/* block.c */
extern int bcreat(char *, int, struct bctx **);
extern int bopen(char *, int, int, struct bctx **);
extern int bput(struct bctx *, void *, size_t, unsigned char *);
extern int bget(struct bctx *, unsigned char *, void *, size_t *);
extern int brm(struct bctx *, unsigned char *);
extern int bgc(struct bctx *);
extern int bcheck(struct bctx *, unsigned char *);
extern int bsync(struct bctx *);
extern int bclose(struct bctx *);

/* bcompress.c */
extern struct bops *bcompressops(void);

/* bencrypt.c */
struct bops *bencryptops(void);

/* bstorage.c */
extern struct bops *bstorageops(void);
