#include <sys/types.h>
#include <sys/stat.h>

#include <err.h>
#include <fcntl.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "arg.h"
#include "config.h"
#include "key.h"
#include "misc.h"
#include "state.h"

struct param param;	/* unused but needed for linking */
int verbose;
char *argv0;

static void
usage(void)
{
	fprintf(stderr, "usage: %s [-v] keyfile\n", argv0);
	exit(1);
}

int
main(int argc, char *argv[])
{
	unsigned char key[KEYSIZE];
	int fd;

	ARGBEGIN {
	case 'v':
		verbose++;
		break;
	default:
		usage();
	} ARGEND

	if (argc != 1)
		usage();

	fd = open(argv[0], O_RDWR | O_CREAT | O_EXCL, 0600);
	if (fd < 0)
		err(1, "open: %s", argv[0]);
	if (keygen(key, sizeof(key)) < 0)
		printerr("keygen");
	if (writekey(fd, key, sizeof(key)) < 0)
		printerr("writekey: %s", argv[0]);
	fsync(fd);
	if (close(fd) < 0)
		err(1, "close: %s", argv[0]);
	return 0;
}
