/*
 * ISC License
 *
 * (c) 2019 Roberto E. Vargas Caballero <k0ga@shike2.com>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

static int
lpack(unsigned char *dst, char *fmt, va_list va)
{
	unsigned char *bp, *cp;
	unsigned s;
	unsigned long l;
	unsigned long long q;
	int n;

	bp = dst;
	while (*fmt) {
		switch (*fmt++) {
		case '\'':
			n = atoi(fmt);
			while (isdigit(*fmt))
				fmt++;
			cp = va_arg(va, unsigned char *);
			while (n--)
				*bp++ = *cp++;
			break;
		case 'c':
			*bp++ = va_arg(va, unsigned);
			break;
		case 's':
			s = va_arg(va, unsigned);
			*bp++ = s;
			*bp++ = s >> 8;
			break;
		case 'l':
			l = va_arg(va, unsigned long);
			*bp++ = l;
			*bp++ = l >> 8;
			*bp++ = l >> 16;
			*bp++ = l >> 24;
			break;
		case 'q':
			q = va_arg(va, unsigned long long);
			*bp++ = q;
			*bp++ = q >> 8;
			*bp++ = q >> 16;
			*bp++ = q >> 24;
			*bp++ = q >> 32;
			*bp++ = q >> 40;
			*bp++ = q >> 48;
			*bp++ = q >> 56;
			break;
		default:
			va_end(va);
			return -1;
		}
	}

	return bp - dst;
}

int
pack(unsigned char *dst, char *fmt, ...)
{
	int r;
	int (*fn)(unsigned char *dst, char *fmt, va_list va);
	va_list va;

	va_start(va, fmt);
	fn = lpack;
	r = (*fn)(dst, fmt, va);
	va_end(va);

	return r;
}
