#include <sys/types.h>

#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "blake2.h"
#include "dedup.h"

int
blake2si(struct hash_ctx *ctx, size_t n)
{
	return blake2s_init(&ctx->u.blake2s_ctx, n);
}

int
blake2su(struct hash_ctx *ctx, const void *buf, size_t n)
{
	return blake2s_update(&ctx->u.blake2s_ctx, buf, n);
}

int
blake2sf(struct hash_ctx *ctx, void *buf, size_t n)
{
	return blake2s_final(&ctx->u.blake2s_ctx, buf, n);
}
