#include <sys/types.h>

#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "blake2.h"
#include "dedup.h"

int
blake2bpi(struct hash_ctx *ctx, size_t n)
{
	return blake2bp_init(&ctx->u.blake2bp_ctx, n);
}

int
blake2bpu(struct hash_ctx *ctx, const void *buf, size_t n)
{
	return blake2bp_update(&ctx->u.blake2bp_ctx, buf, n);
}

int
blake2bpf(struct hash_ctx *ctx, void *buf, size_t n)
{
	return blake2bp_final(&ctx->u.blake2bp_ctx, buf, n);
}
