#include <sys/types.h>

#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "blake2.h"
#include "dedup.h"

int
blake2bi(struct hash_ctx *ctx, size_t n)
{
	return blake2b_init(&ctx->u.blake2b_ctx, n);
}

int
blake2bu(struct hash_ctx *ctx, const void *buf, size_t n)
{
	return blake2b_update(&ctx->u.blake2b_ctx, buf, n);
}

int
blake2bf(struct hash_ctx *ctx, void *buf, size_t n)
{
	return blake2b_final(&ctx->u.blake2b_ctx, buf, n);
}
