#include <sys/types.h>

#include <err.h>
#include <stdint.h>
#include <string.h>

#include <lz4.h>

#include "blake2.h"
#include "dedup.h"

int
lz4_init(struct compr_ctx *ctx)
{
	return 0;
}

size_t
lz4_size(struct compr_ctx *ctx, size_t n)
{
	return LZ4_compressBound(n);
}

size_t
lz4_compr(struct compr_ctx *ctx, const void *in, void *out,
          size_t insize, size_t outsize)
{
	int n;

	n = LZ4_compress_default((char *)in, (char *)out, insize,
	                         outsize);
	if (n < 0)
		errx(1, "LZ4_compress_default failed");
	return n;
}

size_t
lz4_decompr(struct compr_ctx *ctx, const void *in, void *out,
            size_t insize, size_t outsize)
{
	int n;

	n = LZ4_decompress_safe((char *)in, (char *)out, insize,
	                        outsize);
	if (n < 0)
		errx(1, "LZ4_decompress_safe failed");
	return n;
}

int
lz4_final(struct compr_ctx *ctx)
{
	return 0;
}
