#include <sys/types.h>

#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "blake2.h"
#include "dedup.h"

int
blake2spi(struct hash_ctx *ctx, size_t n)
{
	return blake2sp_init(&ctx->u.blake2sp_ctx, n);
}

int
blake2spu(struct hash_ctx *ctx, const void *buf, size_t n)
{
	return blake2sp_update(&ctx->u.blake2sp_ctx, buf, n);
}

int
blake2spf(struct hash_ctx *ctx, void *buf, size_t n)
{
	return blake2sp_final(&ctx->u.blake2sp_ctx, buf, n);
}
