#include <sys/types.h>

#include <err.h>
#include <stdint.h>
#include <string.h>

#include <snappy-c.h>

#include "blake2.h"
#include "dedup.h"

int
snappy_init(struct compr_ctx *ctx)
{
	return 0;
}

size_t
snappy_size(struct compr_ctx *ctx, size_t n)
{
	return snappy_max_compressed_length(n);
}

size_t
snappy_compr(struct compr_ctx *ctx, const void *in, void *out,
          size_t insize, size_t outsize)
{
	size_t n = outsize;
	snappy_status ret;

	ret = snappy_compress((char *)in, insize, (char *)out, &n);
	if (ret != SNAPPY_OK)
		errx(1, "snappy_compress failed: %d", ret);
	return n;
}

size_t
snappy_decompr(struct compr_ctx *ctx, const void *in, void *out,
            size_t insize, size_t outsize)
{
	size_t n = outsize;
	snappy_status ret;

	ret = snappy_uncompress((char *)in, insize, (char *)out, &n);
	if (ret != SNAPPY_OK)
		errx(1, "snappy_uncompress failed: %d", ret);
	return n;
}

int
snappy_final(struct compr_ctx *ctx)
{
	return 0;
}
