#include <err.h>
#include <stdint.h>
#include <string.h>

#include <lz4.h>

int compr_enabled = 1;

size_t
compr_size(size_t size)
{
	size_t ret;

	if (compr_enabled)
		ret = LZ4_compressBound(size);
	else
		ret = size;

	return ret;
}

size_t
compr(uint8_t *in, uint8_t *out, size_t insize, size_t outsize)
{
	int ret;

	if (compr_enabled) {
		ret = LZ4_compress_default((char *)in, (char *)out, insize,
		                           outsize);
		if (ret < 0)
			errx(1, "LZ4_compress_default failed");
	} else {
		ret = insize;
		memcpy(out, in, insize);
	}

	return ret;
}

size_t
decompr(uint8_t *in, uint8_t *out, size_t insize, size_t outsize)
{
	int ret;

	if (compr_enabled) {
		ret = LZ4_decompress_safe((char *)in, (char *)out, insize,
		                          outsize);
		if (ret < 0)
			errx(1, "LZ4_decompress_safe failed");
	} else {
		ret = insize;
		memcpy(out, in, insize);
	}

	return ret;
}
