#!/bin/sh
# output ascii plot of hashtag evolution generated with extract-memecount.sh

if [ $# -lt 1 ]; then
	printf 'usage: %s <file>\n' "$0" >&2
	exit 1
fi

[ "$2" = "semilog" ] && semilog="set log y"

gnuplot - <<__EOF__
set term dumb
set title "annna meme count (total on $(date +%Y-%m-%d): \
$(awk 'END{print $3}' "$1")) $semilog"
set xdata time
set format x "%Y-%m"
set timefmt "%Y-%m-%d"
set xtics 2592000*4
$semilog
plot '$1' u 1:3 w lp t '' pt 13
__EOF__

if [ -z "$semilog" ]; then
	gnuplot - <<__EOF__
reset
set term dumb
set title "annna meme growth (new memes per day)"
set xdata time
set format x "%Y-%m"
set timefmt "%Y-%m-%d"
set xtics 2592000*4
set log y
plot '$1' u 1:5 w lp t '' pt 13
__EOF__
fi
