#!/bin/sh
# output formatted table with memecache media statistics

# estimated average image viewing time [s]
img_viewing_time=5

if [ $# -ne 1 ]; then
	printf 'usage: %s <memecache_path>\n' "$0" >&2
	exit 1
fi

oldpathfile="memecache_pathcache.txt.old"
touch "${oldpathfile}"
oldstatusfile="${oldpathfile}.status"
todofile="memecache_pathcache.txt.todo"
touch "${todofile}"
pathfile="memecache_pathcache.txt"

find "$1" \
	-maxdepth 1 \
	-type f \
	\! \( -name '*.orig' \
		-o -name '*.nochip' \
		-o -name '*.txt' \
		-o -name '*.meme' \
		-o -name '*.pdf' \
	\) \
	| sort > "${pathfile}"
comm -3 "${pathfile}" "${oldpathfile}" > "${todofile}"

i=0
sum=0.0
# Get state.
if [ -e "${oldstatusfile}" ]; then
	sum="$(head -n 1 "${oldstatusfile}")"
	i="$(tail -n 1 "${oldstatusfile}")"
fi

# Old work on diff.
fifofile="$(mktemp -u media-stats.fifo.XXXXXX)"
mkfifo ${fifofile}
grep '.*mkv$\|.*mp4$\|.*webm$\|.*mp3$\|.*ogg$' "${todofile}" \
	2>/dev/null >${fifofile} &
while read -r f; do
	i=$((i+=1))
	new_sum="$(printf '%f + %f\n' \
		"$(ffprobe -v error -show_entries format=duration \
		   -of default=noprint_wrappers=1:nokey=1 "$f")" "$sum" 2>/dev/null | \
		   bc -l)"
	sum="$new_sum"
done < ${fifofile}
rm -f ${fifofile}

# Store state.
cp "${pathfile}" "${oldpathfile}"
printf "%f\n%i\n" "${sum}" "${i}" > "${oldstatusfile}"

n_img="$(grep '.*png$\|.*jpg$\|.*JPG$\|.*gif$' "${pathfile}" \
	2>/dev/null | wc -l)"
n_vid="$(grep '.*mkv$\|.*mp4$\|.*webm$\|.*mp3$|.*ogg$' "${pathfile}" \
	2>/dev/null | wc -l)"

printf '\n                      '
printf '+----- statistics (%s) ------+\n' "$(date '+%Y-%m-%d')"
printf '                      '
printf '| number of images:     %8s     |\n' "$n_img"
printf '                      '
printf '| number of movies:     %8s     |\n' "$n_vid"
printf '                      '
printf '| average movie length: %10.1f s |\n' \
	"$(printf '%f/%f\n' "$sum" "$i" | bc -l)"
printf '                      '
printf '| total image viewing time: %6.1f h |\n' \
	"$(printf '%s*%f/3600\n' "$n_img" "$img_viewing_time" | bc -l)"
printf '                      '
printf '|   (assuming %d s per image)         |\n' "$img_viewing_time"
printf '                      '
printf '| total movie length:   %10.1f h |\n' \
	"$(printf '%s/3600\n' "$sum" | bc -l)"
printf '                      '
printf '+------------------------------------+\n'

