/* 
 * chkpasswd.c - check is user/pwd  match 
 *
 Michele Andreoli
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <termios.h>
#include <getopt.h>
#include <malloc.h>
#include <fcntl.h>
#include <pwd.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <sys/resource.h>

#if defined (__GNU_LIBRARY__) && __GNU_LIBRARY__ > 1
#include <crypt.h>
#endif


extern int is_local(char *);		/* islocal.c */
extern int setpwnam(struct passwd *);	/* setpwnam.c */

#define ascii_to_bin(c) ((c)>='a'?(c-59):(c)>='A'?((c)-53):(c)-'.')
#define bin_to_ascii(c) ((c)>=38?((c)-38+'a'):(c)>=12?((c)-12+'A'):(c)+'.')


int
main(argc, argv)
     int argc;
     char *argv[];
{
    struct passwd *pe;
    uid_t gotuid = getuid();
    char *pwdstr = NULL, *cryptstr, *oldstr;
    char pwdstr1[10];
    char *user;
    char salt[2];

	user=argv[1];
	pwdstr=argv[2];


if ( (user==NULL ) || (pwdstr==NULL) )
	{
	fprintf(stderr,"Syntax: chkpasswd user password\n");
	exit (1);
	}

    if(!(pe = getpwnam(user))) {
	fprintf(stderr,"Can't find username anywhere. Is `%s' really a user?",
	 user);
	exit (1);
    }
    

    if ( !strncmp(pe->pw_passwd, crypt(pwdstr, pe->pw_passwd), 13) ) {
        fprintf(stderr,"Match.\n");
        exit(0);
    }
        fprintf(stderr,"Don't match, imposter.\n");

exit(1);

}
