title	'bank and move module for CP/M 3'
;
;
true	equ	-1		;
false	equ	not true	;
;
banked	equ	true	;true if banked
;

;
	cseg			;must be in shared memory
;
	public	?move,?xmove,?bank	;
	extrn	@cbnk			;
;
	maclib 	z80		
	maclib	ports
;
;
?xmove:
	if	banked
	mov	a,b		;get destination bank
	sta	dest$bank	;save bank #
	mov	a,c		;get source bank #
	sta	sourc$bank	;save it
	mvi	a,0ffh		;set xmove flag true
	sta	xmove$flag	;store it
	endif
	ret			;
;
	if	banked
dest$bank	db	0	;
sourc$bank	db	0	;
xmove$flag	db	0	;		
	endif
;
;
?move:
	if	banked
	lda	xmove$flag	;see if interbank move
	ora	a		;set flag
	jnz	bank$move	;if interbank move jump, else simple move
	endif
	xchg			;pass source to <DE> and dest to <HL>
	ldir			;use z80 block move instruction
	xchg			;need next address in same regs
	ret			;return,  move is done
	if	banked 
bank$move:
	xra	a		;zero a reg
	sta	xmove$flag	;reset interbank move flag
	lda	sourc$bank	;get source bank
	call	?bank		;select bank
;
	push	d		;save source address
	push	h		;save destination address
	push	b		;save count
;
	lxi	h,copy$buffer	;point ot copy buffer
	xchg			;swap source and destination
	ldir			;load buffer
;
	lda	dest$bank	;get destination bank
	call	?bank		;switch bank if need to
;
	pop	b		;restore count
	pop	d		;restore destination
	push	b		;save count
;
	lxi	h,copy$buffer	;point to copy buffer
	ldir			;empty buffer
;
	pop	b		;
	pop	h		;
	dad	b		;
	xchg			;set values for return
	lda	@cbnk		;get curent bank (in common)
	call	?bank		;set to old bank
	ret			;go back
;
copy$buffer	ds	128	;128 byte copy buffer
	endif
;
;
;
?bank:
	ora	a	;see if bank 0 to select
	jz	set0	;jump if 0
	mvi	a,80h	;must be bank 1
set0:	out	bank$port	;set to bank 0
	ret		;done
;
	end		;
