;------------------------------------------------------------------------
; The following routines set various video modes on VGA and EGA systems.
; It is assumed that the calling routine has already determined that
; the proper equipment exists to make this call work.
;	On entry: Nothing assumed
;	Modifies: Assume everything
;	Returns:  carry flag clear if successful, set if unsuccessful
;
;	Based on Listing 10-10 from _Programmer's Guide to PC & PS/2
;		Video Systems_ by Richard Wilton, 1987 Microsoft Press
;------------------------------------------------------------------------
 VGA50	PROC NEAR


   ;establish 80x25 alphanumeric mode with 400-line vertical resolution
	mov		ax,1202h		; 12H = int 10h function number
						; 02  = select 400 scan lines
	mov		bl,30h		; subfunction
	int		10h
	cmp		al,12h
	jne		_vga_50_err	; probably means VGA inactive

	mov		ax,3			; ah=0 (int 10h function number)
						; al=3 (80x25 16 color mode)
	int		10h
						;no error abort here -- function doesn't
						;return consistent error value for
						;setting invalid mode

 ;load video BIOS 8x8 characters into alphanumeric character generator
	mov		ax,1112h		;al = 8x8 character set load
	mov		bl,0			;bl = block to load
	int		10h
	jmp		short _vga50_ret

 _VGA_50_err:
	call beep
	stc
	ret

 _VGA50_ret:
	mov		ah,01h
	mov		cx,0607h		;set cursor mode for color
	mov		cursor_type,cx
	int		10h
	clc
	ret

 VGA50 ENDP

 VGA25	PROC NEAR

  ;establish 80x25 alphanumeric mode with 350-line vertical resolution
	mov		ax,1202h		; 12H = int 10h function number
						; 01 = 400 scan lines
	mov		bl,30h		; subfunction
	int		10h

	mov		ax,3			; ah=0 (int 10h function number)
						; al=3 (80x25 16 color mode)
	int		10h
						;no error abort here -- function doesn't
						;return consistent error value for
						;setting invalid mode

 ;load video BIOS 8x16 characters into alphanumeric character generator
	mov		ax,1114h		;al = 8x16 character set load
	mov		bl,0			;bl = block to load
	int		10h
	jmp		short _vga25_ret

 _VGA_25_err:
	call beep
	stc
	ret

 _VGA25_ret:
	clc
	ret

 VGA25 ENDP


 EGA43	PROC NEAR


   ;establish 80x25 alphanumeric mode with 350-line vertical resolution
	mov		ax,1201h		; 12H = int 10h function number
						; 01  = select 350 scan lines
	mov		bl,30h		; subfunction
	int		10h

	mov		ax,3			; ah=0 (int 10h function number)
						; al=3 (80x25 16 color mode)
	int		10h
						;no error abort here -- function doesn't
						;return consistent error value for
						;setting invalid mode

 ;load video BIOS 8x8 characters into alphanumeric character generator
     mov       ax,1112h       ;al = 8x8 character set load
	mov		bl,0			;bl = block to load
	int		10h

 ;set cursor position in character matrix
	call		fix_ega_cursor
	jmp		short _ega43_ret

 _ega43_err:
	call beep
	stc
	ret

 _ega43_ret:
	mov		ah,01h
	mov		cx,0607h		;set cursor mode for color
	mov		cursor_type,cx
	int		10h
	clc
	ret

 EGA43 ENDP

 EGA25	PROC NEAR

  ;establish 80x25 alphanumeric mode with 350-line vertical resolution
	mov		ax,1201h		; 12H = int 10h function number
						; 01 = 350 scan lines
	mov		bl,30h		; subfunction
	int		10h

	mov		ax,3			; ah=0 (int 10h function number)
						; al=3 (80x25 16 color mode)
	int		10h
						;no error abort here -- function doesn't
						;return consistent error value for
						;setting invalid mode

 ;load video BIOS 8x14 characters into alphanumeric character generator
	mov		ax,1111h		;al = 8x8 character set load
	mov		bl,0			;bl = block to load
	int		10h

  ;set cursor position in character matrix
	call		fix_ega_cursor

	jmp		short _ega25_ret

 _EGA_25_err:
	call beep
	stc
	ret

 _EGA25_ret:
	clc
	ret

 EGA25 ENDP

 FIX_EGA_CURSOR PROC NEAR
	mov		ax,40h
	mov		es,ax          ;ES->video BIOS data area
	mov		dx,es:[63h]	;DX = CRTC address port
	mov		ax,060Ah		;AH = 6 (cursor start value)
						;AL = 0Ah (cursor start reg number)
	out		dx,ax		;update CRTC cursor start
	mov		ax,000Bh
	out		dx,ax

	mov		ax,cs		;restore es
	mov		es,ax
	ret

 FIX_EGA_CURSOR	ENDP

;------------------------------------------------------------------------------
; Swaps between a nominal 25 line video display and a 43/50 line display.
; Assumes IS_VGA and IS_EGA variables (and scr_ht) all correctly
; identify the active subsystems and the current height.  Modifies
; scr_ht when done and calls video_init and read_dir to clean everything up
; correctly when done.
;-----------------------------------------------------------------------------

 SWAP_VIDEO_MODE	PROC NEAR


	cmp		scr_ht,25
	jne		_SVM_2
	call		is_uv_ar		;If ultravision active and resident,
						;use UV screen mode change directly
	jnc		_SVM_0
	mov		ax,0CD12h      ;80x43 or 80x50
	int		10h
	cmp		ax,0CDCDh		;if invalid mode, exit
	je		_svm_ret
	mov		ah,01h
	mov		cx,0607h		;set cursor mode for color
	mov		cursor_type,cx
	int		10h
	jmp		short _svm_ret
 _svm_0:
	cmp		IS_VGA,1
	jne		_SVM_1
	call		vga50
	mov		scr_ht,50
	jmp		short _svm_ret
 _SVM_1:
	cmp		IS_EGA,1
	jne		_svm_err		;is neither EGA or VGA, exit with error
	call		ega43
	jmp		short _svm_ret
 _SVM_2:
	call		is_uv_ar		;If ultravision active and resident,
						;use UV screen mode change directly
	jnc		_SVM_2_5
	mov		ax,0CD11h
	int		10h
	cmp		ax,0CDCDh		;if invalid mode, exit
	je		_svm_ret
	mov		ah,01h
	mov		cx,0607h		;set cursor mode for color
	mov		cursor_type,cx
	int		10h
	jmp		short _svm_ret
 _SVM_2_5:
	cmp		IS_VGA,1
	jne		_svm_3
	call		vga25
	mov		scr_ht,25
	jmp		short _svm_ret
 _SVM_3:
	call		ega25
	mov		scr_ht,25
	jmp		short _svm_ret
 _svm_err:
	call		beep
	ret
 _svm_ret:
	call		video_init
;	call		read_dir   ;no-no was causing work directory to = destination
;	call		clr_scr
;	call		refresh_dir_disp
;	call		put_menu_paths
	call		refresh

	push		es
	mov		ax,40h
	mov		es,ax		;point to video bios area

	mov		cx,scr_ht
	dec		cx
	mov		es:[84h],cl	;ROWS
	pop		es

	ret
 SWAP_VIDEO_MODE	ENDP


;----------------------------------------------------------------------
; Calculates the offset in the video buffer.
; On entry: AX = column number
;           BX = row number
; Also uses DX, put preserves entry value
; On return: Puts total offset in VOFFSET
;----------------------------------------------------------------------
 V_OFF PROC NEAR

	push		ax
	push		bx
	push		dx		;preserve value of dx
	xchg		ax,bx
	shl		ax,1		;multiplies column by 2
	mov		dx,80
	mul		dx
	shl		bx,1
	add		ax,bx
	mov		VOFFSET,ax
	pop		dx
	pop		bx
	pop		ax

	ret

 V_OFF ENDP


;-------------------------------------------------------------------------
; Initializes the various location and other variables which are
; dependent upon screen height.
;-------------------------------------------------------------------------

 VIDEO_INIT    PROC NEAR

     call      get_rows
     mov       cx,ax
     mov       scr_ht,ax

;     mov       bx,scr_ht
     dec       ax
     mov       view_rows,ax
     sub       ax,4
     mov       dir_rows,ax
;	add		bx,ROW1
;	mov		last_row,bx

	xor		ax,ax
	mov		bx,dir_rows
	call		v_off
	mov		dx,voffset
	add		dx,bar_start
	mov		dir_row_end,dx

;     mov       bx,scr_ht
;     dec       bx
;     mov       view_rows,bx

	mov		ax,2
	mov		bx,scr_ht
	dec		bx
	call		v_off
	mov		dx,voffset
	mov		SUBDIR_LOC,dx
	dec		bx
	call		v_off
	mov		dx,voffset
	mov		D_FREE_LOC,dx
	dec		bx
	call		v_off
	mov		dx,voffset
	mov		FILES_LOC,dx

	mov		ax,scr_ht
	dec		ax
	mov		cl,8
	shl		ax,cl        ;*100h
	add		ax,79
	mov		end_window,ax

	ret

 VIDEO_INIT 	ENDP

;----------------------------------------------------------------------------
; Returns # of rows stored in video BIOS in al
; ah guaranteed 0
;---------------------------------------------------------------------------
 GET_ROWS PROC NEAR

     push      cx
     push      es
	mov		ax,40h
	mov		es,ax		;point to video bios area

	mov		cx,es:[84h]	;ROWS
	and		cx,0FFh		;mask out high byte
	pop		es
	inc		cx
     mov       ax,cx
     pop       cx
     ret

 GET_ROWS endp

EGA EQU 02h
MCGA EQU 03h
VGA EQU 04h

;----------------------------------------------------------------------------
; Identifies the active video subsystem.  Sets IS_VGA variable to 1 if
; subsystem is VGA or MCGA.  Sets IS_EGA variable to 1 if is EGA.
; On entry: nothing
; Modifies: AX
; Returns:  nothing.  Modifies IS_EGA and IS_VGA variables.
;           (BX also still contains the video subsystem codes.
;----------------------------------------------------------------------------

 IDENT_DISPLAY		PROC NEAR

	call		get_adapter
	cmp		al,EGA
	je		_id_ega
	cmp		al,MCGA		;MCGA, treat like VGA
	je		_id_vga
	cmp		al,VGA		;MCGA, treat like VGA
	je		_id_vga
	jmp		short _id_ret	;couldn't identify

 _id_vga:
	mov		IS_VGA,1
	jmp		short _id_ret
 _id_ega:
	mov		IS_EGA,1
 _id_ret:
	ret

 IDENT_DISPLAY ENDP

;---------------------------------------------------------------------------
; Ultravision recognition and setting routines
;	On entry: nothing
;	Modifies: AX,CX,BX,DX,SI
;	Returns:  Carry flag set is UV resident and active
;--------------------------------------------------------------------------

 IS_UV_RESIDENT		PROC NEAR

	mov		AX,0CC00h
	int		10h
	cmp		CX,0ABCDh		;is UV resident
	jne		_iur_no		;no?  exit


	stc
	ret
 _iur_no:
	clc
	ret
 IS_UV_RESIDENT		ENDP


 IS_UV_ACTIVE		PROC NEAR

	mov		AX,0CC00h
	int		10h
	cmp		al,0			;is UV active?
	jne		_iua_no
	stc
	ret
 _iua_no:
	clc
	ret

 IS_UV_ACTIVE		ENDP

 IS_UV_AR		PROC NEAR

	call		IS_UV_RESIDENT
	jnc		_AR_NO
	call		IS_UV_ACTIVE
	jnc		_AR_NO
	stc
	ret
 _AR_NO:
	clc
	ret
 IS_UV_AR		ENDP


;--------------------------------------------------------------------------
; Gets the dimensions (rows and columns) for the current UV mode.  If
; the columns are not equal to 80, this procedure sets an 80x25 mode.
; Rows and columns are read from the Video BIOS data area.
;-------------------------------------------------------------------------

 GET_UV_DIMS		PROC NEAR

 _gud_0:
	push		es
	mov		ax,40h
	mov		es,ax		;point to video bios area

	mov		ax,0CD04h		;gets UV mode
	int		10h
	mov		uv_mode_save,al  ;and saves it
	mov		cx,es:[4Ah]	;CRT_COLS
	cmp		cl,80          ;are there 80 columns in this mode?
	je		_gud_1         ;yes? OK we'll use this mode
	mov		ah,0CDh        ;otherwise switch to
	mov		al,11h	     ;standard 80x25 mode
	int		10h

 _gud_1:
	mov		cx,es:[84h]	;look at ROWS in ROM BIOS
	and		cx,0FFh		;mask out high byte
	inc		cx
	mov		scr_ht,cx      ;store as the screen height variable

	pop		es
	ret

 GET_UV_DIMS		ENDP

;NAME:    GET_ADAPTER
;
;DESC:    Returns the active display adapter type.
;
;IN: None
;
;OUT:     AL        active display adapter code
;         00 = MDA
;         01 = CGA
;         02 = EGA
;         03 = MCGA
;         04 = VGA
;
get_adapter    proc near
		push	es
		push	bp
		push	di
		push	si
		push	dx
		push	cx
		push	bx

          mov  dh,ah          ;DH holds original AH
          xor  bx,bx
          mov  es,bx          ;ES -> segment at 0000h
          mov  dl,VGA         ;assume VGA (04h)
          mov  ax,1A00h  ; ** VGA check **
          int  10h       ;check for a VGA
          cmp  al,1Ah         ;is VGA/MCGA supported?
           jne get_adap_020   ;  n: go check for an EGA
          xchg ax,bx          ;  y: move active code to AL
          cmp  al,08h         ;is active monitor a VGA color?
           je  get_adap_060   ;  y: VGA return
          cmp  al,07h         ;is active monitor a VGA mono?
           je  get_adap_060   ;  y: VGA return
          dec  dx        ;assume MCGA (03h)
          cmp  al,0Ah         ; ** MCGA check **
           jb  get_adap_020   ;is active monitor a MCGA?
          cmp  al,0Ch         ;  n: fall through to EGA
           jbe get_adap_060   ;  y: MCGA return
get_adap_020:  mov  dl,EGA         ;assume EGA (02h)
          mov  ah,12h         ; ** EGA check **
          mov  bl,10h         ;get EGA configuration
          int  10h
          cmp  bl,10h         ;valid EGA mem size?
           jb  get_adap_060   ;  y: EGA return
          dec  dx        ;assume CGA (01h)
          cmp  word ptr es:[463h],3B4h
           jne get_adap_060   ;CGA return if not MDA
          dec  dx        ;MDA (00h)
get_adap_060:  xchg ax,dx          ;return AL; restore AH
          pop bx
		pop cx
		pop dx
		pop si
		pop di
		pop bp
		pop es
          ret
get_adapter endp

;-------------------------------------------------------------------------
; Selects the video page for VGA & EGA systems based on the videopage
; variable in the user-configurable settings.  Allows any settings, and
; will check validity of set page and set page to 0 if invalid
;--------------------------------------------------------------------------

set_videopage  proc near

     push ax
     push bx

     mov  ah,5
     mov  al,videopage
     int  10h

     push ax
     mov  ah,0Fh
     int  10h
     pop  ax

     cmp  al,bh          ;is the current page the one we tried to set it to?
     je   page_set_ok

page_notset_ok:
     mov  videopage,0    ;we need this in a couple of places, so square w/ reality
     mov  ax,0500h
     int  10h            ;set the page to 0

page_set_ok:
     pop  bx
     pop  ax
     ret

set_videopage  endp

;--------------------------------------------------------------------------
; Gets the videopage on entry so can reset on exit
; Returns active video page in BH
;--------------------------------------------------------------------------

get_videopage proc near

     push ax
     mov  al,is_ega
     add  al,is_vga
     jz   _gvp_ret

     mov  ah,0Fh
     int  10h
_gvp_ret:
     pop  ax
     ret

get_videopage  endp

;--------------------------------------------------------------------------
; Increment video segment address based on video page
;--------------------------------------------------------------------------

increment_vseg proc near

     push ax
     push bx
     push cx
     mov  al,is_ega
     add  al,is_vga
     jz   _ivs_ret

     mov  ah,0Fh
     int  10h

     xor  cx,cx
     mov  cl,bh     ;put page number in cl
     cmp  cx,0
     je   _ivs_ret
_ivs_loop:
     add  VIDEO_SEG,100h
     loop _ivs_loop

_ivs_ret:
     pop  cx
     pop  bx
     pop  ax
     ret
increment_vseg endp